/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl;

import java.util.ArrayList;
import java.util.List;
import org.graylog2.syslog4j.SyslogBackLogHandlerIF;
import org.graylog2.syslog4j.SyslogMessageModifierIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.AbstractSyslogConfigIF;
import org.graylog2.syslog4j.impl.backlog.printstream.SystemErrSyslogBackLogHandler;
import org.graylog2.syslog4j.util.SyslogUtility;

public abstract class AbstractSyslogConfig
implements AbstractSyslogConfigIF {
    private static final long serialVersionUID = -3728308557871358111L;
    protected static final List defaultBackLogHandlers = new ArrayList();
    protected int facility = 8;
    protected String charSet = "UTF-8";
    protected String ident = "";
    protected String localName = null;
    protected boolean sendLocalTimestamp = true;
    protected boolean sendLocalName = true;
    protected boolean includeIdentInMessageModifier = false;
    protected boolean throwExceptionOnWrite = false;
    protected boolean throwExceptionOnInitialize = true;
    protected int maxMessageLength = 1024;
    protected byte[] splitMessageBeginText = "...".getBytes();
    protected byte[] splitMessageEndText = "...".getBytes();
    protected List messageModifiers = null;
    protected List backLogHandlers = null;
    protected boolean threaded = true;
    protected boolean useDaemonThread = true;
    protected int threadPriority = -1;
    protected long threadLoopInterval = 500L;
    protected int writeRetries = 2;
    protected long maxShutdownWait = 30000L;
    protected boolean truncateMessage = false;
    protected boolean useStructuredData = false;

    @Override
    public abstract Class getSyslogClass();

    @Override
    public String getCharSet() {
        return this.charSet;
    }

    @Override
    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public void setLocalName(String localName) {
        this.localName = localName;
    }

    @Override
    public boolean isThrowExceptionOnWrite() {
        return this.throwExceptionOnWrite;
    }

    @Override
    public void setThrowExceptionOnWrite(boolean throwExceptionOnWrite) {
        this.throwExceptionOnWrite = throwExceptionOnWrite;
    }

    @Override
    public boolean isThrowExceptionOnInitialize() {
        return this.throwExceptionOnInitialize;
    }

    @Override
    public void setThrowExceptionOnInitialize(boolean throwExceptionOnInitialize) {
        this.throwExceptionOnInitialize = throwExceptionOnInitialize;
    }

    @Override
    public byte[] getSplitMessageBeginText() {
        return this.splitMessageBeginText;
    }

    @Override
    public void setSplitMessageBeginText(byte[] splitMessageBeginText) {
        this.splitMessageBeginText = splitMessageBeginText;
    }

    public void setSplitMessageBeginText(String splitMessageBeginText) throws SyslogRuntimeException {
        this.splitMessageBeginText = SyslogUtility.getBytes(this, splitMessageBeginText);
    }

    @Override
    public byte[] getSplitMessageEndText() {
        return this.splitMessageEndText;
    }

    @Override
    public void setSplitMessageEndText(byte[] splitMessageEndText) {
        this.splitMessageEndText = splitMessageEndText;
    }

    public void setSplitMessageEndText(String splitMessageEndText) throws SyslogRuntimeException {
        this.splitMessageEndText = SyslogUtility.getBytes(this, splitMessageEndText);
    }

    @Override
    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Override
    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    @Override
    public boolean isSendLocalTimestamp() {
        return this.sendLocalTimestamp;
    }

    @Override
    public void setSendLocalTimestamp(boolean sendLocalTimestamp) {
        this.sendLocalTimestamp = sendLocalTimestamp;
    }

    @Override
    public boolean isSendLocalName() {
        return this.sendLocalName;
    }

    @Override
    public void setSendLocalName(boolean sendLocalName) {
        this.sendLocalName = sendLocalName;
    }

    @Override
    public int getFacility() {
        return this.facility;
    }

    @Override
    public void setFacility(int facility) {
        this.facility = facility;
    }

    @Override
    public void setFacility(String facilityName) {
        this.facility = SyslogUtility.getFacility(facilityName);
    }

    @Override
    public String getIdent() {
        return this.ident;
    }

    @Override
    public void setIdent(String ident) {
        this.ident = ident;
    }

    protected synchronized List _getMessageModifiers() {
        if (this.messageModifiers == null) {
            this.messageModifiers = new ArrayList();
        }
        return this.messageModifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageModifier(SyslogMessageModifierIF messageModifier) {
        List _messageModifiers;
        if (messageModifier == null) {
            return;
        }
        List list = _messageModifiers = this._getMessageModifiers();
        synchronized (list) {
            _messageModifiers.add(messageModifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertMessageModifier(int index, SyslogMessageModifierIF messageModifier) {
        List _messageModifiers;
        if (messageModifier == null) {
            return;
        }
        List list = _messageModifiers = this._getMessageModifiers();
        synchronized (list) {
            try {
                _messageModifiers.add(index, messageModifier);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new SyslogRuntimeException(ioobe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageModifier(SyslogMessageModifierIF messageModifier) {
        List _messageModifiers;
        if (messageModifier == null) {
            return;
        }
        List list = _messageModifiers = this._getMessageModifiers();
        synchronized (list) {
            _messageModifiers.remove(messageModifier);
        }
    }

    @Override
    public List getMessageModifiers() {
        return this.messageModifiers;
    }

    public void setMessageModifiers(List messageModifiers) {
        this.messageModifiers = messageModifiers;
    }

    @Override
    public void removeAllMessageModifiers() {
        if (this.messageModifiers == null || this.messageModifiers.isEmpty()) {
            return;
        }
        this.messageModifiers.clear();
    }

    protected synchronized List _getBackLogHandlers() {
        if (this.backLogHandlers == null) {
            this.backLogHandlers = new ArrayList();
        }
        return this.backLogHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBackLogHandler(SyslogBackLogHandlerIF backLogHandler) {
        List _backLogHandlers;
        if (backLogHandler == null) {
            return;
        }
        List list = _backLogHandlers = this._getBackLogHandlers();
        synchronized (list) {
            backLogHandler.initialize();
            _backLogHandlers.add(backLogHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertBackLogHandler(int index, SyslogBackLogHandlerIF backLogHandler) {
        List _backLogHandlers;
        if (backLogHandler == null) {
            return;
        }
        List list = _backLogHandlers = this._getBackLogHandlers();
        synchronized (list) {
            try {
                backLogHandler.initialize();
                _backLogHandlers.add(index, backLogHandler);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new SyslogRuntimeException(ioobe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBackLogHandler(SyslogBackLogHandlerIF backLogHandler) {
        List _backLogHandlers;
        if (backLogHandler == null) {
            return;
        }
        List list = _backLogHandlers = this._getBackLogHandlers();
        synchronized (list) {
            _backLogHandlers.remove(backLogHandler);
        }
    }

    @Override
    public List getBackLogHandlers() {
        if (this.backLogHandlers == null || this.backLogHandlers.size() < 1) {
            return defaultBackLogHandlers;
        }
        return this.backLogHandlers;
    }

    public void setBackLogHandlers(List backLogHandlers) {
        this.backLogHandlers = backLogHandlers;
    }

    @Override
    public void removeAllBackLogHandlers() {
        if (this.backLogHandlers == null || this.backLogHandlers.isEmpty()) {
            return;
        }
        this.backLogHandlers.clear();
    }

    @Override
    public boolean isIncludeIdentInMessageModifier() {
        return this.includeIdentInMessageModifier;
    }

    @Override
    public void setIncludeIdentInMessageModifier(boolean includeIdentInMessageModifier) {
        this.includeIdentInMessageModifier = includeIdentInMessageModifier;
    }

    @Override
    public boolean isThreaded() {
        return this.threaded;
    }

    @Override
    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    @Override
    public boolean isUseDaemonThread() {
        return this.useDaemonThread;
    }

    @Override
    public void setUseDaemonThread(boolean useDaemonThread) {
        this.useDaemonThread = useDaemonThread;
    }

    @Override
    public int getThreadPriority() {
        return this.threadPriority;
    }

    @Override
    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    @Override
    public long getThreadLoopInterval() {
        return this.threadLoopInterval;
    }

    @Override
    public void setThreadLoopInterval(long threadLoopInterval) {
        this.threadLoopInterval = threadLoopInterval;
    }

    @Override
    public long getMaxShutdownWait() {
        return this.maxShutdownWait;
    }

    @Override
    public void setMaxShutdownWait(long maxShutdownWait) {
        this.maxShutdownWait = maxShutdownWait;
    }

    @Override
    public int getWriteRetries() {
        return this.writeRetries;
    }

    @Override
    public void setWriteRetries(int writeRetries) {
        this.writeRetries = writeRetries;
    }

    @Override
    public boolean isTruncateMessage() {
        return this.truncateMessage;
    }

    @Override
    public void setTruncateMessage(boolean truncateMessage) {
        this.truncateMessage = truncateMessage;
    }

    @Override
    public boolean isUseStructuredData() {
        return this.useStructuredData;
    }

    @Override
    public void setUseStructuredData(boolean useStructuredData) {
        this.useStructuredData = useStructuredData;
    }

    @Override
    public Class getSyslogWriterClass() {
        return null;
    }

    static {
        defaultBackLogHandlers.add(new SystemErrSyslogBackLogHandler());
    }
}

