/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.server.impl;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.graylog2.syslog4j.SyslogCharSetIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.server.SyslogServerConfigIF;
import org.graylog2.syslog4j.server.SyslogServerEventHandlerIF;
import org.graylog2.syslog4j.server.SyslogServerEventIF;
import org.graylog2.syslog4j.server.SyslogServerIF;
import org.graylog2.syslog4j.server.SyslogServerSessionEventHandlerIF;
import org.graylog2.syslog4j.server.SyslogServerSessionlessEventHandlerIF;
import org.graylog2.syslog4j.server.impl.AbstractSyslogServerConfig;
import org.graylog2.syslog4j.server.impl.event.SyslogServerEvent;
import org.graylog2.syslog4j.server.impl.event.structured.StructuredSyslogServerEvent;
import org.graylog2.syslog4j.util.SyslogUtility;

public abstract class AbstractSyslogServer
implements SyslogServerIF {
    protected String syslogProtocol = null;
    protected AbstractSyslogServerConfig syslogServerConfig = null;
    protected Thread thread = null;
    protected boolean shutdown = false;

    @Override
    public void initialize(String protocol, SyslogServerConfigIF config) throws SyslogRuntimeException {
        this.syslogProtocol = protocol;
        try {
            this.syslogServerConfig = (AbstractSyslogServerConfig)config;
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException(cce);
        }
        this.initialize();
    }

    @Override
    public String getProtocol() {
        return this.syslogProtocol;
    }

    @Override
    public SyslogServerConfigIF getConfig() {
        return this.syslogServerConfig;
    }

    protected abstract void initialize() throws SyslogRuntimeException;

    @Override
    public void shutdown() throws SyslogRuntimeException {
        this.shutdown = true;
    }

    @Override
    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void setThread(Thread thread) {
        this.thread = thread;
    }

    protected static boolean isStructuredMessage(SyslogCharSetIF syslogCharSet, byte[] receiveData) {
        String receiveDataString = SyslogUtility.newString(syslogCharSet, receiveData);
        boolean isStructuredMessage = AbstractSyslogServer.isStructuredMessage(syslogCharSet, receiveDataString);
        return isStructuredMessage;
    }

    protected static boolean isStructuredMessage(SyslogCharSetIF syslogCharSet, String receiveData) {
        int idx = receiveData.indexOf(62);
        return idx != -1 && receiveData.length() > idx + 1 && Character.isDigit(receiveData.charAt(idx + 1));
    }

    protected static SyslogServerEventIF createEvent(SyslogServerConfigIF serverConfig, byte[] lineBytes, int lineBytesLength, InetAddress inetAddr) {
        SyslogServerEvent event = null;
        if (serverConfig.isUseStructuredData() && AbstractSyslogServer.isStructuredMessage((SyslogCharSetIF)serverConfig, lineBytes)) {
            event = new StructuredSyslogServerEvent(lineBytes, lineBytesLength, inetAddr);
            if (serverConfig.getDateTimeFormatter() != null) {
                ((StructuredSyslogServerEvent)event).setDateTimeFormatter(serverConfig.getDateTimeFormatter());
            }
        } else {
            event = new SyslogServerEvent(lineBytes, lineBytesLength, inetAddr);
        }
        return event;
    }

    protected static SyslogServerEventIF createEvent(SyslogServerConfigIF serverConfig, String line, InetAddress inetAddr) {
        SyslogServerEvent event = null;
        event = serverConfig.isUseStructuredData() && AbstractSyslogServer.isStructuredMessage((SyslogCharSetIF)serverConfig, line) ? new StructuredSyslogServerEvent(line, inetAddr) : new SyslogServerEvent(line, inetAddr);
        return event;
    }

    public static void handleInitialize(SyslogServerIF syslogServer) {
        List eventHandlers = syslogServer.getConfig().getEventHandlers();
        for (int i = 0; i < eventHandlers.size(); ++i) {
            SyslogServerEventHandlerIF eventHandler = (SyslogServerEventHandlerIF)eventHandlers.get(i);
            try {
                eventHandler.initialize(syslogServer);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void handleDestroy(SyslogServerIF syslogServer) {
        List eventHandlers = syslogServer.getConfig().getEventHandlers();
        for (int i = 0; i < eventHandlers.size(); ++i) {
            SyslogServerEventHandlerIF eventHandler = (SyslogServerEventHandlerIF)eventHandlers.get(i);
            try {
                eventHandler.destroy(syslogServer);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void handleSessionOpen(Sessions sessions, SyslogServerIF syslogServer, Socket socket) {
        List eventHandlers = syslogServer.getConfig().getEventHandlers();
        for (int i = 0; i < eventHandlers.size(); ++i) {
            SyslogServerEventHandlerIF eventHandler = (SyslogServerEventHandlerIF)eventHandlers.get(i);
            if (!(eventHandler instanceof SyslogServerSessionEventHandlerIF)) continue;
            try {
                Object session = ((SyslogServerSessionEventHandlerIF)eventHandler).sessionOpened(syslogServer, socket.getRemoteSocketAddress());
                if (session == null) continue;
                sessions.addSession(socket, eventHandler, session);
                continue;
            }
            catch (Exception exception) {
                try {
                    ((SyslogServerSessionEventHandlerIF)eventHandler).exception(null, syslogServer, socket.getRemoteSocketAddress(), exception);
                    continue;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    public static void handleSessionClosed(Sessions sessions, SyslogServerIF syslogServer, Socket socket, boolean timeout) {
        List eventHandlers = syslogServer.getConfig().getEventHandlers();
        for (int i = 0; i < eventHandlers.size(); ++i) {
            SyslogServerEventHandlerIF eventHandler = (SyslogServerEventHandlerIF)eventHandlers.get(i);
            if (!(eventHandler instanceof SyslogServerSessionEventHandlerIF)) continue;
            Object session = sessions.getSession(socket, eventHandler);
            try {
                ((SyslogServerSessionEventHandlerIF)eventHandler).sessionClosed(session, syslogServer, socket.getRemoteSocketAddress(), timeout);
                continue;
            }
            catch (Exception exception) {
                try {
                    ((SyslogServerSessionEventHandlerIF)eventHandler).exception(session, syslogServer, socket.getRemoteSocketAddress(), exception);
                    continue;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    public static void handleEvent(Sessions sessions, SyslogServerIF syslogServer, DatagramPacket packet, SyslogServerEventIF event) {
        AbstractSyslogServer.handleEvent(sessions, syslogServer, null, packet.getSocketAddress(), event);
    }

    public static void handleEvent(Sessions sessions, SyslogServerIF syslogServer, Socket socket, SyslogServerEventIF event) {
        AbstractSyslogServer.handleEvent(sessions, syslogServer, socket, socket.getRemoteSocketAddress(), event);
    }

    protected static void handleEvent(Sessions sessions, SyslogServerIF syslogServer, Socket socket, SocketAddress socketAddress, SyslogServerEventIF event) {
        List eventHandlers = syslogServer.getConfig().getEventHandlers();
        for (int i = 0; i < eventHandlers.size(); ++i) {
            Object session;
            SyslogServerEventHandlerIF eventHandler = (SyslogServerEventHandlerIF)eventHandlers.get(i);
            Object object = session = sessions != null && socket != null ? sessions.getSession(socket, eventHandler) : null;
            if (eventHandler instanceof SyslogServerSessionEventHandlerIF) {
                try {
                    ((SyslogServerSessionEventHandlerIF)eventHandler).event(session, syslogServer, socketAddress, event);
                }
                catch (Exception exception) {
                    try {
                        ((SyslogServerSessionEventHandlerIF)eventHandler).exception(session, syslogServer, socketAddress, exception);
                    }
                    catch (Exception exception2) {}
                }
                continue;
            }
            if (!(eventHandler instanceof SyslogServerSessionlessEventHandlerIF)) continue;
            try {
                ((SyslogServerSessionlessEventHandlerIF)eventHandler).event(syslogServer, socketAddress, event);
                continue;
            }
            catch (Exception exception) {
                try {
                    ((SyslogServerSessionlessEventHandlerIF)eventHandler).exception(syslogServer, socketAddress, exception);
                    continue;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
        }
    }

    public static void handleException(Object session, SyslogServerIF syslogServer, SocketAddress socketAddress, Exception exception) {
        List eventHandlers = syslogServer.getConfig().getEventHandlers();
        for (int i = 0; i < eventHandlers.size(); ++i) {
            SyslogServerEventHandlerIF eventHandler = (SyslogServerEventHandlerIF)eventHandlers.get(i);
            if (eventHandler instanceof SyslogServerSessionEventHandlerIF) {
                try {
                    ((SyslogServerSessionEventHandlerIF)eventHandler).exception(session, syslogServer, socketAddress, exception);
                }
                catch (Exception exception2) {}
                continue;
            }
            if (!(eventHandler instanceof SyslogServerSessionlessEventHandlerIF)) continue;
            try {
                ((SyslogServerSessionlessEventHandlerIF)eventHandler).exception(syslogServer, socketAddress, exception);
                continue;
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
    }

    public static class Sessions
    extends HashMap {
        private static final long serialVersionUID = -4438949276263772580L;
        public static final Object syncObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSocket(Socket socket) {
            Object object = syncObject;
            synchronized (object) {
                this.put(socket, new HashMap());
            }
        }

        public Iterator getSockets() {
            if (this.size() > 0) {
                return this.keySet().iterator();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSession(Socket socket, SyslogServerEventHandlerIF eventHandler, Object session) {
            Object object = syncObject;
            synchronized (object) {
                HashMap<SyslogServerEventHandlerIF, Object> handlerMap = this.getHandlerMap(socket);
                if (handlerMap == null) {
                    handlerMap = new HashMap<SyslogServerEventHandlerIF, Object>();
                }
                handlerMap.put(eventHandler, session);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSocket(Socket socket) {
            Object object = syncObject;
            synchronized (object) {
                Map handlerMap = this.getHandlerMap(socket);
                if (handlerMap != null) {
                    handlerMap.clear();
                }
            }
        }

        protected Map getHandlerMap(Socket socket) {
            Map handlerMap = null;
            if (this.containsKey(socket)) {
                handlerMap = (Map)this.get(socket);
            }
            return handlerMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getSession(Socket socket, SyslogServerEventHandlerIF eventHandler) {
            Object object = syncObject;
            synchronized (object) {
                Map handlerMap = this.getHandlerMap(socket);
                Object session = handlerMap.get(eventHandler);
                return session;
            }
        }
    }
}

