/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.message.processor.structured;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.graylog2.syslog4j.impl.message.processor.AbstractSyslogMessageProcessor;
import org.graylog2.syslog4j.impl.message.structured.StructuredSyslogMessage;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class StructuredSyslogMessageProcessor
extends AbstractSyslogMessageProcessor {
    private static final long serialVersionUID = -1563777226913475257L;
    public static String VERSION = "1";
    private static final StructuredSyslogMessageProcessor INSTANCE;
    protected static StructuredSyslogMessageProcessor defaultInstance;
    private String applicationName = "unknown";
    private String processId = "-";
    private DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();

    public static void setDefault(StructuredSyslogMessageProcessor messageProcessor) {
        if (messageProcessor != null) {
            defaultInstance = messageProcessor;
        }
    }

    public static StructuredSyslogMessageProcessor getDefault() {
        return defaultInstance;
    }

    public StructuredSyslogMessageProcessor() {
    }

    public StructuredSyslogMessageProcessor(String applicationName) {
        this.applicationName = applicationName;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Override
    public void appendTimestamp(StringBuffer buffer, Date datetime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(datetime.getTime());
        String formatedTimestamp = formatter.format(calendar.getTime());
        buffer.append(formatedTimestamp);
        buffer.append(' ');
    }

    @Override
    public String createSyslogHeader(int facility, int level, String localName, boolean sendLocalTimestamp, boolean sendLocalName) {
        return this.createSyslogHeaderInner(facility, level, localName, new Date());
    }

    @Override
    public String createSyslogHeader(int facility, int level, String localName, boolean sendLocalName, Date datetime) {
        return this.createSyslogHeaderInner(facility, level, localName, datetime);
    }

    private String createSyslogHeaderInner(int facility, int level, String localName, Date datetime) {
        StringBuffer buffer = new StringBuffer();
        this.appendPriority(buffer, facility, level);
        buffer.append(VERSION);
        buffer.append(' ');
        this.appendTimestamp(buffer, datetime);
        this.appendLocalName(buffer, localName);
        buffer.append(StructuredSyslogMessage.nilProtect(this.applicationName)).append(' ');
        buffer.append(StructuredSyslogMessage.nilProtect(this.processId)).append(' ');
        return buffer.toString();
    }

    static {
        defaultInstance = INSTANCE = new StructuredSyslogMessageProcessor();
    }
}

