/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.Checksum;
import org.greenrobot.essentials.io.IoUtils;

public class FileUtils {
    public static byte[] readBytes(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        return IoUtils.readAllBytesAndClose(is);
    }

    public static void writeBytes(File file, byte[] content) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            ((OutputStream)out).write(content);
        }
        finally {
            IoUtils.safeClose(out);
        }
    }

    public static String readUtf8(File file) throws IOException {
        return FileUtils.readChars(file, "UTF-8");
    }

    public static String readChars(File file, String charset) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), charset);
        return IoUtils.readAllCharsAndClose(reader);
    }

    public static void writeUtf8(File file, CharSequence text) throws IOException {
        FileUtils.writeChars(file, "UTF-8", text, false);
    }

    public static void appendUtf8(File file, CharSequence text) throws IOException {
        FileUtils.writeChars(file, "UTF-8", text, true);
    }

    public static void writeChars(File file, String charset, CharSequence text, boolean apppend) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, apppend), charset);
        IoUtils.writeAllCharsAndClose(writer, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(from));
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(to));
            try {
                IoUtils.copyAllBytes(in, out);
            }
            finally {
                IoUtils.safeClose(out);
            }
        }
        finally {
            IoUtils.safeClose(in);
        }
    }

    public static void copyFile(String fromFilename, String toFilename) throws IOException {
        FileUtils.copyFile(new File(fromFilename), new File(toFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(File file) throws IOException, ClassNotFoundException {
        FileInputStream fileIn = new FileInputStream(file);
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(fileIn));
        try {
            Object object = in.readObject();
            return object;
        }
        finally {
            IoUtils.safeClose(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(File file, Object object) throws IOException {
        FileOutputStream fileOut = new FileOutputStream(file);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(fileOut));
        try {
            out.writeObject(object);
            out.flush();
            fileOut.getFD().sync();
        }
        finally {
            IoUtils.safeClose(out);
        }
    }

    public static String getMd5(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            String string = IoUtils.getMd5(in);
            return string;
        }
        finally {
            IoUtils.safeClose(in);
        }
    }

    public static String getSha1(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            String string = IoUtils.getSha1(in);
            return string;
        }
        finally {
            IoUtils.safeClose(in);
        }
    }

    public static void updateChecksum(File file, Checksum checksum) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            IoUtils.updateChecksum(in, checksum);
        }
        finally {
            IoUtils.safeClose(in);
        }
    }
}

