/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import sun.misc.Unsafe;

public abstract class PrimitiveArrayUtils {
    private static volatile PrimitiveArrayUtils instanceUnsafe;
    private static final PrimitiveArrayUtils instanceSafe;

    public static PrimitiveArrayUtils getInstance() {
        PrimitiveArrayUtils instance = instanceUnsafe;
        if (instance == null) {
            instance = instanceSafe;
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean initUnsafeInstance() {
        if (instanceUnsafe != null || UnsafeImpl.UNSAFE == null) return false;
        Class<PrimitiveArrayUtils> clazz = PrimitiveArrayUtils.class;
        synchronized (PrimitiveArrayUtils.class) {
            if (instanceUnsafe != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
            try {
                instanceUnsafe = new UnsafeImpl();
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
            catch (Throwable throwable) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return false;
            }
        }
    }

    public static PrimitiveArrayUtils getInstanceSafe() {
        return instanceSafe;
    }

    public abstract int getIntLE(byte[] var1, int var2);

    public abstract int getIntBE(byte[] var1, int var2);

    public abstract long getLongLE(byte[] var1, int var2);

    public abstract long getLongBE(byte[] var1, int var2);

    public abstract int getIntLE(char[] var1, int var2);

    static {
        instanceSafe = new SafeImpl();
    }

    private static class SafeImpl
    extends PrimitiveArrayUtils {
        private SafeImpl() {
        }

        @Override
        public int getIntLE(byte[] bytes, int index) {
            return bytes[index] & 0xFF | (bytes[index + 1] & 0xFF) << 8 | (bytes[index + 2] & 0xFF) << 16 | bytes[index + 3] << 24;
        }

        @Override
        public int getIntBE(byte[] bytes, int index) {
            return bytes[index + 3] & 0xFF | (bytes[index + 2] & 0xFF) << 8 | (bytes[index + 1] & 0xFF) << 16 | bytes[index] << 24;
        }

        @Override
        public long getLongLE(byte[] bytes, int index) {
            return (long)(bytes[index] & 0xFF | (bytes[index + 1] & 0xFF) << 8 | (bytes[index + 2] & 0xFF) << 16) | ((long)bytes[index + 3] & 0xFFL) << 24 | ((long)bytes[index + 4] & 0xFFL) << 32 | ((long)bytes[index + 5] & 0xFFL) << 40 | ((long)bytes[index + 6] & 0xFFL) << 48 | (long)bytes[index + 7] << 56;
        }

        @Override
        public long getLongBE(byte[] bytes, int index) {
            return (long)(bytes[index + 7] & 0xFF | (bytes[index + 6] & 0xFF) << 8 | (bytes[index + 5] & 0xFF) << 16) | ((long)bytes[index + 4] & 0xFFL) << 24 | ((long)bytes[index + 3] & 0xFFL) << 32 | ((long)bytes[index + 2] & 0xFFL) << 40 | ((long)bytes[index + 1] & 0xFFL) << 48 | (long)bytes[index] << 56;
        }

        @Override
        public int getIntLE(char[] chars, int index) {
            return chars[index] & 0xFFFF | (chars[index + 1] & 0xFFFF) << 16;
        }
    }

    private static class UnsafeImpl
    extends PrimitiveArrayUtils {
        private static final boolean BIG_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        private static final boolean UNALIGNED = UnsafeImpl.initUnaligned();
        private static final Unsafe UNSAFE;
        private static final long BYTE_ARRAY_OFFSET;
        private static final long CHAR_ARRAY_OFFSET;

        private UnsafeImpl() {
        }

        private static boolean initUnaligned() {
            boolean isAndroid;
            String javaVendor = System.getProperty("java.vendor");
            boolean bl = isAndroid = javaVendor != null ? javaVendor.contains("Android") : false;
            if (isAndroid) {
                return UnsafeImpl.guessUnalignedFromOsArch();
            }
            try {
                Class<?> bitsClass = Class.forName("java.nio.Bits", false, ClassLoader.getSystemClassLoader());
                Method unalignedMethod = bitsClass.getDeclaredMethod("unaligned", new Class[0]);
                unalignedMethod.setAccessible(true);
                return Boolean.TRUE.equals(unalignedMethod.invoke(null, new Object[0]));
            }
            catch (Throwable t) {
                return UnsafeImpl.guessUnalignedFromOsArch();
            }
        }

        private static boolean guessUnalignedFromOsArch() {
            String arch = System.getProperty("os.arch");
            return arch != null && arch.matches("^(i[3-6]86|x86(_64)?|x64|amd64)$");
        }

        private static Unsafe initUnsafe() {
            try {
                Field unsafeField;
                try {
                    unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                }
                catch (NoSuchElementException e) {
                    unsafeField = Unsafe.class.getDeclaredField("THE_ONE");
                }
                unsafeField.setAccessible(true);
                Unsafe unsafe = (Unsafe)unsafeField.get(null);
                byte[] test = new byte[]{-54, -2, -70, -66};
                int testInt = unsafe.getInt(test, unsafe.arrayBaseOffset(byte[].class));
                if (testInt == -889275714) {
                    if (BIG_ENDIAN) {
                        return unsafe;
                    }
                    System.err.println("Big endian confusion");
                } else if (testInt == -1095041334) {
                    if (!BIG_ENDIAN) {
                        return unsafe;
                    }
                    System.err.println("Little endian confusion");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        @Override
        public int getIntLE(byte[] bytes, int index) {
            int value = UNSAFE.getInt(bytes, BYTE_ARRAY_OFFSET + (long)index);
            if (BIG_ENDIAN) {
                return Integer.reverseBytes(value);
            }
            return value;
        }

        @Override
        public int getIntLE(char[] chars, int index) {
            int value = UNSAFE.getInt(chars, CHAR_ARRAY_OFFSET + (long)(index << 2));
            if (BIG_ENDIAN) {
                return Integer.reverseBytes(value);
            }
            return value;
        }

        @Override
        public int getIntBE(byte[] bytes, int index) {
            int value = UNSAFE.getInt(bytes, BYTE_ARRAY_OFFSET + (long)index);
            if (BIG_ENDIAN) {
                return value;
            }
            return Integer.reverseBytes(value);
        }

        @Override
        public long getLongLE(byte[] bytes, int index) {
            long value = UNSAFE.getLong(bytes, BYTE_ARRAY_OFFSET + (long)index);
            if (BIG_ENDIAN) {
                return Long.reverseBytes(value);
            }
            return value;
        }

        @Override
        public long getLongBE(byte[] bytes, int index) {
            long value = UNSAFE.getLong(bytes, BYTE_ARRAY_OFFSET + (long)index);
            if (BIG_ENDIAN) {
                return value;
            }
            return Long.reverseBytes(value);
        }

        static {
            if (UNALIGNED) {
                UNSAFE = UnsafeImpl.initUnsafe();
                if (UNSAFE != null) {
                    BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
                    CHAR_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(char[].class);
                } else {
                    BYTE_ARRAY_OFFSET = 0L;
                    CHAR_ARRAY_OFFSET = 0L;
                }
            } else {
                UNSAFE = null;
                BYTE_ARRAY_OFFSET = 0L;
                CHAR_ARRAY_OFFSET = 0L;
            }
        }
    }
}

