/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials.hash;

import java.io.UnsupportedEncodingException;
import java.util.zip.Checksum;

public class PrimitiveDataChecksum
implements Checksum {
    private final Checksum checksum;

    public PrimitiveDataChecksum(Checksum checksum) {
        this.checksum = checksum;
    }

    @Override
    public void update(int b) {
        this.checksum.update(b);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.checksum.update(b, off, len);
    }

    @Override
    public long getValue() {
        return this.checksum.getValue();
    }

    @Override
    public void reset() {
        this.checksum.reset();
    }

    public void updateUtf8(String string) {
        if (string != null) {
            byte[] bytes;
            try {
                bytes = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.update(bytes, 0, bytes.length);
        }
    }

    public void updateUtf8(String[] strings) {
        if (strings != null) {
            for (String string : strings) {
                this.updateUtf8(string);
            }
        }
    }

    public void updateBoolean(boolean value) {
        this.update(value ? 1 : 0);
    }

    public void updateShort(short number) {
        this.update(number >>> 8 & 0xFF);
        this.update(number & 0xFF);
    }

    public void updateInt(int number) {
        this.update(number >>> 24 & 0xFF);
        this.update(number >>> 16 & 0xFF);
        this.update(number >>> 8 & 0xFF);
        this.update(number & 0xFF);
    }

    public void updateLong(long number) {
        this.update((int)(number >>> 56) & 0xFF);
        this.update((int)(number >>> 48) & 0xFF);
        this.update((int)(number >>> 40) & 0xFF);
        this.update((int)(number >>> 32) & 0xFF);
        this.update((int)(number >>> 24) & 0xFF);
        this.update((int)(number >>> 16) & 0xFF);
        this.update((int)(number >>> 8) & 0xFF);
        this.update((int)(number & 0xFFL));
    }

    public void updateFloat(float number) {
        this.updateInt(Float.floatToIntBits(number));
    }

    public void updateDouble(double number) {
        this.updateLong(Double.doubleToLongBits(number));
    }

    @Override
    public void update(byte[] numbers) {
        if (numbers != null) {
            this.update(numbers, 0, numbers.length);
        }
    }

    public void update(short[] numbers) {
        if (numbers != null) {
            for (short number : numbers) {
                this.updateShort(number);
            }
        }
    }

    public void update(int[] numbers) {
        if (numbers != null) {
            for (int number : numbers) {
                this.updateInt(number);
            }
        }
    }

    public void update(long[] numbers) {
        if (numbers != null) {
            for (long number : numbers) {
                this.updateLong(number);
            }
        }
    }

    public void update(float[] numbers) {
        if (numbers != null) {
            for (float number : numbers) {
                this.updateFloat(number);
            }
        }
    }

    public void update(double[] numbers) {
        if (numbers != null) {
            for (double number : numbers) {
                this.updateDouble(number);
            }
        }
    }
}

