/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.DaoException;
import org.greenrobot.greendao.async.AsyncSession;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.query.QueryBuilder;

public class AbstractDaoSession {
    private final Database db;
    private final Map<Class<?>, AbstractDao<?, ?>> entityToDao;

    public AbstractDaoSession(Database db) {
        this.db = db;
        this.entityToDao = new HashMap();
    }

    protected <T> void registerDao(Class<T> entityClass, AbstractDao<T, ?> dao) {
        this.entityToDao.put(entityClass, dao);
    }

    public <T> long insert(T entity) {
        AbstractDao<?, ?> dao = this.getDao(entity.getClass());
        return dao.insert(entity);
    }

    public <T> long insertOrReplace(T entity) {
        AbstractDao<?, ?> dao = this.getDao(entity.getClass());
        return dao.insertOrReplace(entity);
    }

    public <T> void refresh(T entity) {
        AbstractDao<?, ?> dao = this.getDao(entity.getClass());
        dao.refresh(entity);
    }

    public <T> void update(T entity) {
        AbstractDao<?, ?> dao = this.getDao(entity.getClass());
        dao.update(entity);
    }

    public <T> void delete(T entity) {
        AbstractDao<?, ?> dao = this.getDao(entity.getClass());
        dao.delete(entity);
    }

    public <T> void deleteAll(Class<T> entityClass) {
        AbstractDao<?, ?> dao = this.getDao(entityClass);
        dao.deleteAll();
    }

    public <T, K> T load(Class<T> entityClass, K key) {
        AbstractDao<?, ?> dao = this.getDao(entityClass);
        return (T)dao.load(key);
    }

    public <T, K> List<T> loadAll(Class<T> entityClass) {
        AbstractDao<?, ?> dao = this.getDao(entityClass);
        return dao.loadAll();
    }

    public <T, K> List<T> queryRaw(Class<T> entityClass, String where, String ... selectionArgs) {
        AbstractDao<?, ?> dao = this.getDao(entityClass);
        return dao.queryRaw(where, selectionArgs);
    }

    public <T> QueryBuilder<T> queryBuilder(Class<T> entityClass) {
        AbstractDao<?, ?> dao = this.getDao(entityClass);
        return dao.queryBuilder();
    }

    public AbstractDao<?, ?> getDao(Class<? extends Object> entityClass) {
        AbstractDao<?, ?> dao = this.entityToDao.get(entityClass);
        if (dao == null) {
            throw new DaoException("No DAO registered for " + entityClass);
        }
        return dao;
    }

    public void runInTx(Runnable runnable) {
        this.db.beginTransaction();
        try {
            runnable.run();
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V callInTx(Callable<V> callable) throws Exception {
        this.db.beginTransaction();
        try {
            V result = callable.call();
            this.db.setTransactionSuccessful();
            V v = result;
            return v;
        }
        finally {
            this.db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V callInTxNoException(Callable<V> callable) {
        this.db.beginTransaction();
        try {
            V result;
            try {
                result = callable.call();
            }
            catch (Exception e) {
                throw new DaoException("Callable failed", e);
            }
            this.db.setTransactionSuccessful();
            V v = result;
            return v;
        }
        finally {
            this.db.endTransaction();
        }
    }

    public Database getDatabase() {
        return this.db;
    }

    public Collection<AbstractDao<?, ?>> getAllDaos() {
        return Collections.unmodifiableCollection(this.entityToDao.values());
    }

    public AsyncSession startAsyncSession() {
        return new AsyncSession(this);
    }
}

