/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.query;

import android.database.Cursor;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.query.AbstractQueryData;
import org.greenrobot.greendao.query.AbstractQueryWithLimit;

public class CursorQuery<T>
extends AbstractQueryWithLimit<T> {
    private final QueryData<T> queryData;

    public static <T2> CursorQuery<T2> internalCreate(AbstractDao<T2, ?> dao, String sql, Object[] initialValues) {
        return CursorQuery.create(dao, sql, initialValues, -1, -1);
    }

    static <T2> CursorQuery<T2> create(AbstractDao<T2, ?> dao, String sql, Object[] initialValues, int limitPosition, int offsetPosition) {
        QueryData queryData = new QueryData(dao, sql, CursorQuery.toStringArray(initialValues), limitPosition, offsetPosition);
        return (CursorQuery)queryData.forCurrentThread();
    }

    private CursorQuery(QueryData<T> queryData, AbstractDao<T, ?> dao, String sql, String[] initialValues, int limitPosition, int offsetPosition) {
        super(dao, sql, initialValues, limitPosition, offsetPosition);
        this.queryData = queryData;
    }

    public CursorQuery forCurrentThread() {
        return this.queryData.forCurrentThread(this);
    }

    public Cursor query() {
        this.checkThread();
        return this.dao.getDatabase().rawQuery(this.sql, this.parameters);
    }

    private static final class QueryData<T2>
    extends AbstractQueryData<T2, CursorQuery<T2>> {
        private final int limitPosition;
        private final int offsetPosition;

        QueryData(AbstractDao dao, String sql, String[] initialValues, int limitPosition, int offsetPosition) {
            super(dao, sql, initialValues);
            this.limitPosition = limitPosition;
            this.offsetPosition = offsetPosition;
        }

        @Override
        protected CursorQuery<T2> createQuery() {
            return new CursorQuery(this, this.dao, this.sql, (String[])this.initialValues.clone(), this.limitPosition, this.offsetPosition);
        }
    }
}

