/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao;

import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.greenrobot.greendao.DaoLog;
import org.greenrobot.greendao.database.Database;

public class DbUtils {
    public static void vacuum(Database db) {
        db.execSQL("VACUUM");
    }

    public static int executeSqlScript(Context context, Database db, String assetFilename) throws IOException {
        return DbUtils.executeSqlScript(context, db, assetFilename, true);
    }

    public static int executeSqlScript(Context context, Database db, String assetFilename, boolean transactional) throws IOException {
        byte[] bytes = DbUtils.readAsset(context, assetFilename);
        String sql = new String(bytes, "UTF-8");
        String[] lines = sql.split(";(\\s)*[\n\r]");
        int count = transactional ? DbUtils.executeSqlStatementsInTx(db, lines) : DbUtils.executeSqlStatements(db, lines);
        DaoLog.i("Executed " + count + " statements from SQL script '" + assetFilename + "'");
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeSqlStatementsInTx(Database db, String[] statements) {
        db.beginTransaction();
        try {
            int count = DbUtils.executeSqlStatements(db, statements);
            db.setTransactionSuccessful();
            int n = count;
            return n;
        }
        finally {
            db.endTransaction();
        }
    }

    public static int executeSqlStatements(Database db, String[] statements) {
        int count = 0;
        for (String line : statements) {
            if ((line = line.trim()).length() <= 0) continue;
            db.execSQL(line);
            ++count;
        }
        return count;
    }

    public static int copyAllBytes(InputStream in, OutputStream out) throws IOException {
        int read;
        int byteCount = 0;
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
            byteCount += read;
        }
        return byteCount;
    }

    public static byte[] readAllBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DbUtils.copyAllBytes(in, out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAsset(Context context, String filename) throws IOException {
        try (InputStream in = context.getResources().getAssets().open(filename);){
            byte[] byArray = DbUtils.readAllBytes(in);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logTableDump(SQLiteDatabase db, String tablename) {
        try (Cursor cursor = db.query(tablename, null, null, null, null, null, null);){
            String dump = DatabaseUtils.dumpCursorToString((Cursor)cursor);
            DaoLog.d(dump);
        }
    }
}

