/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.test;

import android.app.Application;
import android.app.Instrumentation;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.test.AndroidTestCase;
import java.util.Random;
import org.greenrobot.greendao.DaoLog;
import org.greenrobot.greendao.DbUtils;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.StandardDatabase;

public abstract class DbTest
extends AndroidTestCase {
    public static final String DB_NAME = "greendao-unittest-db.temp";
    protected final Random random;
    protected final boolean inMemory;
    protected Database db;
    private Application application;

    public DbTest() {
        this(true);
    }

    public DbTest(boolean inMemory) {
        this.inMemory = inMemory;
        this.random = new Random();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.db = this.createDatabase();
    }

    public <T extends Application> T createApplication(Class<T> appClass) {
        Application app;
        DbTest.assertNull((String)"Application already created", (Object)this.application);
        try {
            app = Instrumentation.newApplication(appClass, (Context)this.getContext());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create application " + appClass, e);
        }
        app.onCreate();
        this.application = app;
        return (T)app;
    }

    public void terminateApplication() {
        DbTest.assertNotNull((String)"Application not yet created", (Object)this.application);
        this.application.onTerminate();
        this.application = null;
    }

    public <T extends Application> T getApplication() {
        DbTest.assertNotNull((String)"Application not yet created", (Object)this.application);
        return (T)this.application;
    }

    protected Database createDatabase() {
        SQLiteDatabase sqLiteDatabase;
        if (this.inMemory) {
            sqLiteDatabase = SQLiteDatabase.create(null);
        } else {
            this.getContext().deleteDatabase(DB_NAME);
            sqLiteDatabase = this.getContext().openOrCreateDatabase(DB_NAME, 0, null);
        }
        return new StandardDatabase(sqLiteDatabase);
    }

    protected void tearDown() throws Exception {
        if (this.application != null) {
            this.terminateApplication();
        }
        this.db.close();
        if (!this.inMemory) {
            this.getContext().deleteDatabase(DB_NAME);
        }
        super.tearDown();
    }

    protected void logTableDump(String tablename) {
        if (this.db instanceof StandardDatabase) {
            DbUtils.logTableDump(((StandardDatabase)this.db).getSQLiteDatabase(), tablename);
        } else {
            DaoLog.w("Table dump unsupported for " + this.db);
        }
    }
}

