/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.greenrobot.eclipse.core.commands.AbstractHandler;
import org.greenrobot.eclipse.core.commands.IObjectWithState;
import org.greenrobot.eclipse.core.commands.IStateListener;
import org.greenrobot.eclipse.core.commands.State;

public abstract class AbstractHandlerWithState
extends AbstractHandler
implements IObjectWithState,
IStateListener {
    private Map<String, State> states;
    private static final String[] EMPTY = new String[0];

    @Override
    public void addState(String stateId, State state) {
        if (state == null) {
            throw new NullPointerException("Cannot add a null state");
        }
        if (this.states == null) {
            this.states = new HashMap<String, State>(3);
        }
        this.states.put(stateId, state);
        state.addListener(this);
        this.handleStateChange(state, null);
    }

    @Override
    public final State getState(String stateId) {
        if (this.states == null || this.states.isEmpty()) {
            return null;
        }
        return this.states.get(stateId);
    }

    @Override
    public final String[] getStateIds() {
        if (this.states == null || this.states.isEmpty()) {
            return EMPTY;
        }
        Set<String> stateIds = this.states.keySet();
        return stateIds.toArray(new String[stateIds.size()]);
    }

    @Override
    public void removeState(String stateId) {
        if (stateId == null) {
            throw new NullPointerException("Cannot remove a null state");
        }
        if (this.states == null) {
            return;
        }
        State state = this.states.get(stateId);
        if (state != null) {
            state.removeListener(this);
            if (this.states != null) {
                this.states.remove(stateId);
                if (this.states.isEmpty()) {
                    this.states = null;
                }
            }
        }
    }
}

