/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.expressions;

import java.util.HashMap;
import java.util.Map;
import org.greenrobot.eclipse.core.expressions.IEvaluationContext;
import org.greenrobot.eclipse.core.expressions.IVariableResolver;
import org.greenrobot.eclipse.core.runtime.Assert;
import org.greenrobot.eclipse.core.runtime.CoreException;

public class EvaluationContext
implements IEvaluationContext {
    private IEvaluationContext fParent;
    private Object fDefaultVariable;
    private Map<String, Object> fVariables;
    private IVariableResolver[] fVariableResolvers;
    private Boolean fAllowPluginActivation;

    public EvaluationContext(IEvaluationContext parent, Object defaultVariable) {
        Assert.isNotNull(defaultVariable);
        this.fParent = parent;
        this.fDefaultVariable = defaultVariable;
    }

    public EvaluationContext(IEvaluationContext parent, Object defaultVariable, IVariableResolver[] resolvers) {
        Assert.isNotNull(defaultVariable);
        Assert.isNotNull(resolvers);
        this.fParent = parent;
        this.fDefaultVariable = defaultVariable;
        this.fVariableResolvers = resolvers;
    }

    @Override
    public IEvaluationContext getParent() {
        return this.fParent;
    }

    @Override
    public IEvaluationContext getRoot() {
        if (this.fParent == null) {
            return this;
        }
        return this.fParent.getRoot();
    }

    @Override
    public Object getDefaultVariable() {
        return this.fDefaultVariable;
    }

    @Override
    public void setAllowPluginActivation(boolean value) {
        this.fAllowPluginActivation = value ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean getAllowPluginActivation() {
        if (this.fAllowPluginActivation == null) {
            if (this.fParent != null) {
                return this.fParent.getAllowPluginActivation();
            }
            return false;
        }
        return this.fAllowPluginActivation;
    }

    @Override
    public void addVariable(String name, Object value) {
        Assert.isNotNull(name);
        Assert.isNotNull(value);
        if (this.fVariables == null) {
            this.fVariables = new HashMap<String, Object>();
        }
        this.fVariables.put(name, value);
    }

    @Override
    public Object removeVariable(String name) {
        Assert.isNotNull(name);
        if (this.fVariables == null) {
            return null;
        }
        return this.fVariables.remove(name);
    }

    @Override
    public Object getVariable(String name) {
        Assert.isNotNull(name);
        Object result = null;
        if (this.fVariables != null) {
            result = this.fVariables.get(name);
        }
        if (result != null) {
            return result;
        }
        if (this.fParent != null) {
            return this.fParent.getVariable(name);
        }
        return null;
    }

    @Override
    public Object resolveVariable(String name, Object[] args) throws CoreException {
        if (this.fVariableResolvers != null && this.fVariableResolvers.length > 0) {
            int i = 0;
            while (i < this.fVariableResolvers.length) {
                IVariableResolver resolver = this.fVariableResolvers[i];
                Object variable = resolver.resolve(name, args);
                if (variable != null) {
                    return variable;
                }
                ++i;
            }
        }
        if (this.fParent != null) {
            return this.fParent.resolveVariable(name, args);
        }
        return null;
    }
}

