/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.adapter;

import java.util.Iterator;
import java.util.List;
import org.greenrobot.eclipse.core.internal.adapter.AdapterFactoryProxy;
import org.greenrobot.eclipse.core.internal.runtime.AdapterManager;
import org.greenrobot.eclipse.core.internal.runtime.IAdapterManagerProvider;
import org.greenrobot.eclipse.core.runtime.IAdapterFactory;
import org.greenrobot.eclipse.core.runtime.IConfigurationElement;
import org.greenrobot.eclipse.core.runtime.IExtension;
import org.greenrobot.eclipse.core.runtime.IExtensionPoint;
import org.greenrobot.eclipse.core.runtime.IRegistryEventListener;
import org.greenrobot.eclipse.core.runtime.RegistryFactory;

public final class AdapterManagerListener
implements IRegistryEventListener,
IAdapterManagerProvider {
    public static final String ADAPTER_POINT_ID = "org.greenrobot.eclipse.core.runtime.adapters";
    private AdapterManager theAdapterManager = AdapterManager.getDefault();

    public AdapterManagerListener() {
        this.theAdapterManager.registerLazyFactoryProvider(this);
    }

    public boolean addFactories(AdapterManager adapterManager) {
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint(ADAPTER_POINT_ID);
        if (point == null) {
            return false;
        }
        boolean factoriesAdded = false;
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                AdapterFactoryProxy proxy = AdapterFactoryProxy.createProxy(elements[j]);
                if (proxy != null) {
                    adapterManager.registerFactory(proxy, proxy.getAdaptableType());
                    factoriesAdded = true;
                }
                ++j;
            }
            ++i;
        }
        RegistryFactory.getRegistry().addListener(this, ADAPTER_POINT_ID);
        return factoriesAdded;
    }

    private void registerExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int j = 0;
        while (j < elements.length) {
            AdapterFactoryProxy proxy = AdapterFactoryProxy.createProxy(elements[j]);
            if (proxy != null) {
                this.theAdapterManager.registerFactory(proxy, proxy.getAdaptableType());
            }
            ++j;
        }
    }

    public synchronized void added(IExtension[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            this.registerExtension(extensions[i]);
            ++i;
        }
        this.theAdapterManager.flushLookup();
    }

    public synchronized void removed(IExtension[] extensions) {
        this.theAdapterManager.flushLookup();
        int i = 0;
        while (i < extensions.length) {
            Iterator<List<IAdapterFactory>> it = this.theAdapterManager.getFactories().values().iterator();
            while (it.hasNext()) {
                Iterator<IAdapterFactory> it2 = it.next().iterator();
                while (it2.hasNext()) {
                    IAdapterFactory factory = it2.next();
                    if (!(factory instanceof AdapterFactoryProxy) || !((AdapterFactoryProxy)factory).originatesFrom(extensions[i])) continue;
                    it2.remove();
                }
            }
            ++i;
        }
    }

    public synchronized void added(IExtensionPoint[] extensionPoints) {
    }

    public synchronized void removed(IExtensionPoint[] extensionPoints) {
    }

    public synchronized void stop() {
        RegistryFactory.getRegistry().removeListener(this);
    }
}

