/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.commands.util;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.greenrobot.eclipse.core.commands.Command;

public final class Util {
    public static final SortedMap<?, ?> EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    public static final SortedSet<?> EMPTY_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet());
    public static final String ZERO_LENGTH_STRING = "";

    public static final void assertInstance(Object object, Class<?> c, boolean allowNull) {
        if (object == null && allowNull) {
            return;
        }
        if (object == null || c == null) {
            throw new NullPointerException();
        }
        if (!c.isInstance(object)) {
            throw new IllegalArgumentException();
        }
    }

    public static final int compare(boolean left, boolean right) {
        return !left ? (right ? -1 : 0) : (right ? 0 : 1);
    }

    public static final <T extends Comparable<? super T>> int compare(T left, T right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    public static final int compare(int left, int right) {
        return left - right;
    }

    public static final int compare(Object left, Object right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return left.toString().compareTo(right.toString());
    }

    public static final boolean equals(boolean left, boolean right) {
        return left == right;
    }

    public static final boolean equals(Object left, Object right) {
        return left == null ? right == null : right != null && left.equals(right);
    }

    public static final boolean equals(Object[] leftArray, Object[] rightArray) {
        if (leftArray == null) {
            return rightArray == null;
        }
        if (rightArray == null) {
            return false;
        }
        if (leftArray.length != rightArray.length) {
            return false;
        }
        int i = 0;
        while (i < leftArray.length) {
            boolean equal;
            Object left = leftArray[i];
            Object right = rightArray[i];
            boolean bl = left == null ? right == null : (equal = left.equals(right));
            if (!equal) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final int hashCode(int i) {
        return i;
    }

    public static final int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static final <K, V> Map<K, V> safeCopy(Map<K, V> map, Class<K> keyClass, Class<V> valueClass, boolean allowNullKeys, boolean allowNullValues) {
        if (map == null || keyClass == null || valueClass == null) {
            throw new NullPointerException();
        }
        Map<K, V> copy = Collections.unmodifiableMap(new HashMap<K, V>(map));
        for (Map.Entry<K, V> entry : copy.entrySet()) {
            Util.assertInstance(entry.getKey(), keyClass, allowNullKeys);
            Util.assertInstance(entry.getValue(), valueClass, allowNullValues);
        }
        return copy;
    }

    public static final <T> Set<T> safeCopy(Set<T> set, Class<T> c) {
        return Util.safeCopy(set, c, false);
    }

    public static final <T> Set<T> safeCopy(Set<T> set, Class<T> c, boolean allowNullElements) {
        if (set == null || c == null) {
            throw new NullPointerException();
        }
        Set<T> copy = Collections.unmodifiableSet(new HashSet<T>(set));
        Iterator<T> iterator = copy.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), c, allowNullElements);
        }
        return copy;
    }

    public static final String getHelpContextId(Command command) {
        Method method = null;
        try {
            method = Command.class.getDeclaredMethod("getHelpContextId", new Class[0]);
        }
        catch (Exception exception) {}
        String contextId = null;
        if (method != null) {
            boolean accessible = method.isAccessible();
            method.setAccessible(true);
            try {
                contextId = (String)method.invoke((Object)command, new Object[0]);
            }
            catch (Exception exception) {}
            method.setAccessible(accessible);
        }
        return contextId;
    }

    private Util() {
    }
}

