/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.expressions;

import org.greenrobot.eclipse.core.expressions.EvaluationResult;
import org.greenrobot.eclipse.core.expressions.ExpressionInfo;
import org.greenrobot.eclipse.core.expressions.IEvaluationContext;
import org.greenrobot.eclipse.core.internal.expressions.CompositeExpression;
import org.greenrobot.eclipse.core.internal.expressions.DefaultVariable;
import org.greenrobot.eclipse.core.internal.expressions.ExpressionPlugin;
import org.greenrobot.eclipse.core.internal.expressions.Expressions;
import org.greenrobot.eclipse.core.runtime.Assert;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IAdaptable;
import org.greenrobot.eclipse.core.runtime.IAdapterManager;
import org.greenrobot.eclipse.core.runtime.IConfigurationElement;
import org.greenrobot.eclipse.core.runtime.Platform;
import org.w3c.dom.Element;

public class AdaptExpression
extends CompositeExpression {
    private static final String ATT_TYPE = "type";
    private static final int HASH_INITIAL = AdaptExpression.class.getName().hashCode();
    private String fTypeName;

    public AdaptExpression(IConfigurationElement configElement) throws CoreException {
        this.fTypeName = configElement.getAttribute(ATT_TYPE);
        Expressions.checkAttribute(ATT_TYPE, this.fTypeName);
    }

    public AdaptExpression(Element element) throws CoreException {
        this.fTypeName = element.getAttribute(ATT_TYPE);
        Expressions.checkAttribute(ATT_TYPE, this.fTypeName.length() > 0 ? this.fTypeName : null);
    }

    public AdaptExpression(String typeName) {
        Assert.isNotNull(typeName);
        this.fTypeName = typeName;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AdaptExpression)) {
            return false;
        }
        AdaptExpression that = (AdaptExpression)object;
        return this.fTypeName.equals(that.fTypeName) && AdaptExpression.equals(this.fExpressions, that.fExpressions);
    }

    @Override
    protected int computeHashCode() {
        return HASH_INITIAL * 89 + AdaptExpression.hashCode(this.fExpressions) * 89 + this.fTypeName.hashCode();
    }

    @Override
    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        if (this.fTypeName == null) {
            return EvaluationResult.FALSE;
        }
        Object var = context.getDefaultVariable();
        if (var == null) {
            return EvaluationResult.FALSE;
        }
        Object adapted = null;
        IAdapterManager manager = Platform.getAdapterManager();
        if (Expressions.isInstanceOf(var, this.fTypeName)) {
            adapted = var;
        } else {
            Class<?> typeClazz;
            if (var instanceof IAdaptable && (typeClazz = Expressions.loadClass(var.getClass().getClassLoader(), this.fTypeName)) != null) {
                adapted = ((IAdaptable)var).getAdapter(typeClazz);
            }
            if (adapted == null) {
                if (this.forceLoadEnabled()) {
                    adapted = manager.loadAdapter(var, this.fTypeName);
                } else {
                    adapted = manager.getAdapter(var, this.fTypeName);
                    if (adapted == null) {
                        if (manager.queryAdapter(var, this.fTypeName) == 1) {
                            return EvaluationResult.NOT_LOADED;
                        }
                        return EvaluationResult.FALSE;
                    }
                }
                if (adapted == null) {
                    return EvaluationResult.FALSE;
                }
            }
        }
        return this.evaluateAnd(new DefaultVariable(context, adapted));
    }

    private boolean forceLoadEnabled() {
        return Platform.getPreferencesService().getBoolean(ExpressionPlugin.getPluginId(), "forceLoadAdapters", true, null);
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        info.markDefaultVariableAccessed();
        super.collectExpressionInfo(info);
    }
}

