/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.expressions;

import java.util.HashMap;
import java.util.Map;
import org.greenrobot.eclipse.core.expressions.Expression;
import org.greenrobot.eclipse.core.expressions.ExpressionConverter;
import org.greenrobot.eclipse.core.internal.expressions.ExpressionMessages;
import org.greenrobot.eclipse.core.internal.expressions.ExpressionStatus;
import org.greenrobot.eclipse.core.internal.expressions.Messages;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IConfigurationElement;
import org.greenrobot.eclipse.core.runtime.IExtensionDelta;
import org.greenrobot.eclipse.core.runtime.IExtensionRegistry;
import org.greenrobot.eclipse.core.runtime.IRegistryChangeEvent;
import org.greenrobot.eclipse.core.runtime.IRegistryChangeListener;
import org.greenrobot.eclipse.core.runtime.InvalidRegistryObjectException;
import org.greenrobot.eclipse.core.runtime.Platform;

public class DefinitionRegistry
implements IRegistryChangeListener {
    private Map<String, Expression> cache = null;

    private Map<String, Expression> getCache() {
        if (this.cache == null) {
            this.cache = new HashMap<String, Expression>();
        }
        return this.cache;
    }

    public DefinitionRegistry() {
        Platform.getExtensionRegistry().addRegistryChangeListener(this, "org.greenrobot.eclipse.core.expressions");
    }

    public Expression getExpression(String id) throws CoreException {
        Expression cachedExpression = this.getCache().get(id);
        if (cachedExpression != null) {
            return cachedExpression;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.greenrobot.eclipse.core.expressions", "definitions");
        Expression foundExpression = null;
        int i = 0;
        while (i < ces.length) {
            String cid = ces[i].getAttribute("id");
            if (cid != null && cid.equals(id)) {
                try {
                    foundExpression = this.getExpression(id, ces[i]);
                    break;
                }
                catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                    throw new CoreException(new ExpressionStatus(52, Messages.format(ExpressionMessages.Missing_Expression, id)));
                }
            }
            ++i;
        }
        if (foundExpression == null) {
            throw new CoreException(new ExpressionStatus(52, Messages.format(ExpressionMessages.Missing_Expression, id)));
        }
        return foundExpression;
    }

    private Expression getExpression(String id, IConfigurationElement element) throws InvalidRegistryObjectException, CoreException {
        Expression expr = ExpressionConverter.getDefault().perform(element.getChildren()[0]);
        if (expr != null) {
            this.getCache().put(id, expr);
        }
        return expr;
    }

    @Override
    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] extensionDeltas = event.getExtensionDeltas("org.greenrobot.eclipse.core.expressions", "definitions");
        int i = 0;
        while (i < extensionDeltas.length) {
            if (extensionDeltas[i].getKind() == 2) {
                IConfigurationElement[] ces = extensionDeltas[i].getExtension().getConfigurationElements();
                int j = 0;
                while (j < ces.length) {
                    String id = ces[j].getAttribute("id");
                    if (id != null) {
                        this.getCache().remove(id);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

