/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.expressions;

import org.greenrobot.eclipse.core.expressions.EvaluationResult;
import org.greenrobot.eclipse.core.expressions.Expression;
import org.greenrobot.eclipse.core.expressions.ExpressionInfo;
import org.greenrobot.eclipse.core.expressions.IEvaluationContext;
import org.greenrobot.eclipse.core.internal.expressions.Expressions;
import org.greenrobot.eclipse.core.runtime.Assert;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;

public class InstanceofExpression
extends Expression {
    private static final int HASH_INITIAL = InstanceofExpression.class.getName().hashCode();
    private String fTypeName;

    public InstanceofExpression(IConfigurationElement element) throws CoreException {
        this.fTypeName = element.getAttribute("value");
        Expressions.checkAttribute("value", this.fTypeName);
    }

    public InstanceofExpression(Element element) throws CoreException {
        this.fTypeName = element.getAttribute("value");
        Expressions.checkAttribute("value", this.fTypeName.length() > 0 ? this.fTypeName : null);
    }

    public InstanceofExpression(String typeName) {
        Assert.isNotNull(typeName);
        this.fTypeName = typeName;
    }

    @Override
    public EvaluationResult evaluate(IEvaluationContext context) {
        Object element = context.getDefaultVariable();
        return EvaluationResult.valueOf(Expressions.isInstanceOf(element, this.fTypeName));
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        info.markDefaultVariableAccessed();
    }

    public boolean equals(Object object) {
        if (!(object instanceof InstanceofExpression)) {
            return false;
        }
        InstanceofExpression that = (InstanceofExpression)object;
        return this.fTypeName.equals(that.fTypeName);
    }

    @Override
    protected int computeHashCode() {
        return HASH_INITIAL * 89 + this.fTypeName.hashCode();
    }

    public String toString() {
        return "<instanceof value=\"" + this.fTypeName + "\"/>";
    }
}

