/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.expressions;

import org.greenrobot.eclipse.core.expressions.EvaluationResult;
import org.greenrobot.eclipse.core.expressions.Expression;
import org.greenrobot.eclipse.core.expressions.ExpressionInfo;
import org.greenrobot.eclipse.core.expressions.IEvaluationContext;
import org.greenrobot.eclipse.core.internal.expressions.DefinitionRegistry;
import org.greenrobot.eclipse.core.internal.expressions.Expressions;
import org.greenrobot.eclipse.core.runtime.Assert;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;

public class ReferenceExpression
extends Expression {
    private static DefinitionRegistry fgDefinitionRegistry = null;
    private static final String ATT_DEFINITION_ID = "definitionId";
    private static final int HASH_INITIAL = ReferenceExpression.class.getName().hashCode();
    private String fDefinitionId;

    private static DefinitionRegistry getDefinitionRegistry() {
        if (fgDefinitionRegistry == null) {
            fgDefinitionRegistry = new DefinitionRegistry();
        }
        return fgDefinitionRegistry;
    }

    public ReferenceExpression(String definitionId) {
        Assert.isNotNull(definitionId);
        this.fDefinitionId = definitionId;
    }

    public ReferenceExpression(IConfigurationElement element) throws CoreException {
        this.fDefinitionId = element.getAttribute(ATT_DEFINITION_ID);
        Expressions.checkAttribute(ATT_DEFINITION_ID, this.fDefinitionId);
    }

    public ReferenceExpression(Element element) throws CoreException {
        this.fDefinitionId = element.getAttribute(ATT_DEFINITION_ID);
        Expressions.checkAttribute(ATT_DEFINITION_ID, this.fDefinitionId.length() > 0 ? this.fDefinitionId : null);
    }

    @Override
    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        Expression expr = ReferenceExpression.getDefinitionRegistry().getExpression(this.fDefinitionId);
        return expr.evaluate(context);
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        Expression expr;
        try {
            expr = ReferenceExpression.getDefinitionRegistry().getExpression(this.fDefinitionId);
        }
        catch (CoreException coreException) {
            return;
        }
        expr.collectExpressionInfo(info);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReferenceExpression)) {
            return false;
        }
        ReferenceExpression that = (ReferenceExpression)object;
        return this.fDefinitionId.equals(that.fDefinitionId);
    }

    @Override
    protected int computeHashCode() {
        return HASH_INITIAL * 89 + this.fDefinitionId.hashCode();
    }
}

