/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.expressions;

import org.greenrobot.eclipse.core.expressions.EvaluationContext;
import org.greenrobot.eclipse.core.expressions.EvaluationResult;
import org.greenrobot.eclipse.core.expressions.ExpressionInfo;
import org.greenrobot.eclipse.core.expressions.IEvaluationContext;
import org.greenrobot.eclipse.core.internal.expressions.CompositeExpression;
import org.greenrobot.eclipse.core.internal.expressions.ExpressionMessages;
import org.greenrobot.eclipse.core.internal.expressions.ExpressionStatus;
import org.greenrobot.eclipse.core.internal.expressions.Expressions;
import org.greenrobot.eclipse.core.internal.expressions.Messages;
import org.greenrobot.eclipse.core.runtime.Assert;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;

public class WithExpression
extends CompositeExpression {
    private String fVariable;
    private static final String ATT_VARIABLE = "variable";
    private static final int HASH_INITIAL = WithExpression.class.getName().hashCode();

    public WithExpression(IConfigurationElement configElement) throws CoreException {
        this.fVariable = configElement.getAttribute(ATT_VARIABLE);
        Expressions.checkAttribute(ATT_VARIABLE, this.fVariable);
    }

    public WithExpression(Element element) throws CoreException {
        this.fVariable = element.getAttribute(ATT_VARIABLE);
        Expressions.checkAttribute(ATT_VARIABLE, this.fVariable.length() > 0 ? this.fVariable : null);
    }

    public WithExpression(String variable) {
        Assert.isNotNull(variable);
        this.fVariable = variable;
    }

    public boolean equals(Object object) {
        if (!(object instanceof WithExpression)) {
            return false;
        }
        WithExpression that = (WithExpression)object;
        return this.fVariable.equals(that.fVariable) && WithExpression.equals(this.fExpressions, that.fExpressions);
    }

    @Override
    protected int computeHashCode() {
        return HASH_INITIAL * 89 + WithExpression.hashCode(this.fExpressions) * 89 + this.fVariable.hashCode();
    }

    @Override
    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        Object variable = context.getVariable(this.fVariable);
        if (variable == null) {
            throw new CoreException(new ExpressionStatus(301, Messages.format(ExpressionMessages.WithExpression_variable_not_defined, this.fVariable)));
        }
        if (variable == IEvaluationContext.UNDEFINED_VARIABLE) {
            return EvaluationResult.FALSE;
        }
        return this.evaluateAnd(new EvaluationContext(context, variable));
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        ExpressionInfo other = new ExpressionInfo();
        super.collectExpressionInfo(other);
        if (other.hasDefaultVariableAccess()) {
            info.addVariableNameAccess(this.fVariable);
        }
        info.mergeExceptDefaultVariable(other);
    }
}

