/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.preferences;

import java.util.TreeSet;
import org.greenrobot.eclipse.core.internal.preferences.OSGiPreferencesServiceImpl;
import org.greenrobot.eclipse.core.runtime.preferences.ConfigurationScope;
import org.greenrobot.osgi.framework.Bundle;
import org.greenrobot.osgi.framework.BundleContext;
import org.greenrobot.osgi.framework.BundleEvent;
import org.greenrobot.osgi.framework.BundleListener;
import org.greenrobot.osgi.framework.ServiceFactory;
import org.greenrobot.osgi.framework.ServiceRegistration;
import org.greenrobot.osgi.service.prefs.BackingStoreException;
import org.greenrobot.osgi.service.prefs.Preferences;
import org.greenrobot.osgi.service.prefs.PreferencesService;

public class OSGiPreferencesServiceManager
implements ServiceFactory<PreferencesService>,
BundleListener {
    private static final String ORG_ECLIPSE_CORE_INTERNAL_PREFERENCES_OSGI = "org.greenrobot.eclipse.core.internal.preferences.osgi";
    private Preferences prefBundles;

    public OSGiPreferencesServiceManager(BundleContext context) {
        context.addBundleListener(this);
        this.prefBundles = ConfigurationScope.INSTANCE.getNode(ORG_ECLIPSE_CORE_INTERNAL_PREFERENCES_OSGI);
        try {
            Bundle[] allBundles = context.getBundles();
            TreeSet<String> bundleQualifiers = new TreeSet<String>();
            int i = 0;
            while (i < allBundles.length) {
                bundleQualifiers.add(this.getQualifier(allBundles[i]));
                ++i;
            }
            String[] prefsBundles = this.prefBundles.keys();
            int i2 = 0;
            while (i2 < prefsBundles.length) {
                if (!bundleQualifiers.contains(prefsBundles[i2])) {
                    this.removePrefs(prefsBundles[i2]);
                }
                ++i2;
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    @Override
    public PreferencesService getService(Bundle bundle, ServiceRegistration<PreferencesService> registration) {
        String qualifier = this.getQualifier(bundle);
        Preferences bundlesNode = this.getBundlesNode();
        bundlesNode.put(qualifier, "");
        try {
            bundlesNode.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        return new OSGiPreferencesServiceImpl(ConfigurationScope.INSTANCE.getNode(this.getQualifier(bundle)));
    }

    private String getQualifier(Bundle bundle) {
        String qualifier = "org.greenrobot.eclipse.core.runtime.preferences.OSGiPreferences." + bundle.getBundleId();
        return qualifier;
    }

    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<PreferencesService> registration, PreferencesService service) {
        try {
            ConfigurationScope.INSTANCE.getNode(this.getQualifier(bundle)).flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            try {
                this.removePrefs(this.getQualifier(event.getBundle()));
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    protected void removePrefs(String qualifier) throws BackingStoreException {
        ConfigurationScope.INSTANCE.getNode(qualifier).removeNode();
        Preferences bundlesNode = this.getBundlesNode();
        bundlesNode.remove(qualifier);
        bundlesNode.flush();
    }

    private Preferences getBundlesNode() {
        try {
            if (this.prefBundles == null || !this.prefBundles.nodeExists("")) {
                this.prefBundles = ConfigurationScope.INSTANCE.getNode(ORG_ECLIPSE_CORE_INTERNAL_PREFERENCES_OSGI);
            }
            return this.prefBundles;
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }
}

