/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.preferences;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.greenrobot.eclipse.core.internal.preferences.EclipsePreferences;
import org.greenrobot.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.greenrobot.eclipse.core.internal.preferences.PreferencesService;
import org.greenrobot.eclipse.core.internal.preferences.PrefsMessages;
import org.greenrobot.eclipse.core.internal.preferences.RootPreferences;
import org.greenrobot.eclipse.core.internal.preferences.ScopeDescriptor;
import org.greenrobot.eclipse.core.internal.preferences.exchange.ILegacyPreferences;
import org.greenrobot.eclipse.core.internal.runtime.RuntimeLog;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IConfigurationElement;
import org.greenrobot.eclipse.core.runtime.IExtension;
import org.greenrobot.eclipse.core.runtime.IExtensionDelta;
import org.greenrobot.eclipse.core.runtime.IExtensionPoint;
import org.greenrobot.eclipse.core.runtime.IExtensionRegistry;
import org.greenrobot.eclipse.core.runtime.IRegistryChangeEvent;
import org.greenrobot.eclipse.core.runtime.IRegistryChangeListener;
import org.greenrobot.eclipse.core.runtime.ISafeRunnable;
import org.greenrobot.eclipse.core.runtime.IStatus;
import org.greenrobot.eclipse.core.runtime.ListenerList;
import org.greenrobot.eclipse.core.runtime.SafeRunner;
import org.greenrobot.eclipse.core.runtime.Status;
import org.greenrobot.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.greenrobot.eclipse.core.runtime.preferences.AbstractPreferenceStorage;
import org.greenrobot.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.greenrobot.eclipse.core.runtime.preferences.IScope;
import org.greenrobot.eclipse.core.runtime.preferences.PreferenceModifyListener;
import org.greenrobot.eclipse.osgi.util.NLS;
import org.greenrobot.osgi.framework.Bundle;

public class PreferenceServiceRegistryHelper
implements IRegistryChangeListener {
    private static final String ELEMENT_INITIALIZER = "initializer";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_STORAGE = "storage";
    private static final String ELEMENT_SCOPE = "scope";
    private static final String ELEMENT_MODIFIER = "modifier";
    private static final IExtension[] EMPTY_EXTENSION_ARRAY = new IExtension[0];
    private static final Map<String, Object> scopeRegistry = Collections.synchronizedMap(new HashMap());
    private ListenerList<PreferenceModifyListener> modifyListeners;
    private final PreferencesService service;
    private final IExtensionRegistry registry;

    private static IStatus createStatusError(String message, Exception e) {
        return new Status(4, "org.greenrobot.eclipse.equinox.preferences", 4, message, e);
    }

    private static IStatus createStatusWarning(String message, Exception e) {
        return new Status(2, "org.greenrobot.eclipse.equinox.preferences", 2, message, e);
    }

    private static void log(IStatus status) {
        RuntimeLog.log(status);
    }

    public PreferenceServiceRegistryHelper(PreferencesService service, Object registryObject) {
        this.service = service;
        this.registry = (IExtensionRegistry)registryObject;
        this.initializeScopes();
        this.registry.addRegistryChangeListener(this);
    }

    void stop() {
        this.registry.removeRegistryChangeListener(this);
    }

    private void addModifyListener(IConfigurationElement element) {
        String key = element.getAttribute(ATTRIBUTE_CLASS);
        if (key == null) {
            String message = NLS.bind(PrefsMessages.preferences_missingClassAttribute, element.getDeclaringExtension().getUniqueIdentifier());
            PreferenceServiceRegistryHelper.log(new Status(4, "org.greenrobot.eclipse.equinox.preferences", 4, message, null));
            return;
        }
        try {
            Object listener = element.createExecutableExtension(ATTRIBUTE_CLASS);
            if (!(listener instanceof PreferenceModifyListener)) {
                PreferenceServiceRegistryHelper.log(new Status(4, "org.greenrobot.eclipse.equinox.preferences", 4, PrefsMessages.preferences_classCastListener, null));
                return;
            }
            this.modifyListeners.add((PreferenceModifyListener)listener);
        }
        catch (CoreException e) {
            PreferenceServiceRegistryHelper.log(e.getStatus());
        }
    }

    public WeakReference<Object> applyRuntimeDefaults(String name, WeakReference<Object> pluginReference) {
        IExtension[] extensions = this.getPrefExtensions();
        if (extensions.length == 0) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Skipping runtime default preference customization.");
            }
            return null;
        }
        boolean foundInitializer = false;
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (ELEMENT_INITIALIZER.equals(elements[j].getName()) && name.equals(elements[j].getContributor().getName())) {
                    if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                        IExtension theExtension = elements[j].getDeclaringExtension();
                        String extensionNamespace = theExtension.getContributor().getName();
                        Bundle underlyingBundle = PreferencesOSGiUtils.getDefault().getBundle(extensionNamespace);
                        String ownerName = underlyingBundle != null ? underlyingBundle.getSymbolicName() : extensionNamespace;
                        PrefsMessages.message("Running default preference customization as defined by: " + ownerName);
                    }
                    this.runInitializer(elements[j]);
                    foundInitializer = true;
                }
                ++j;
            }
            ++i;
        }
        if (foundInitializer) {
            return null;
        }
        Object plugin = pluginReference.get();
        ILegacyPreferences initService = PreferencesOSGiUtils.getDefault().getLegacyPreferences();
        if (initService != null) {
            plugin = initService.init(plugin, name);
        }
        return new WeakReference<Object>(plugin);
    }

    public IEclipsePreferences createNode(RootPreferences parent, String name) {
        IScope scope = null;
        Object value = scopeRegistry.get(name);
        if (value instanceof IConfigurationElement) {
            if (((IConfigurationElement)value).getAttribute(ATTRIBUTE_CLASS) != null) {
                try {
                    scope = (IScope)((IConfigurationElement)value).createExecutableExtension(ATTRIBUTE_CLASS);
                    scopeRegistry.put(name, scope);
                }
                catch (ClassCastException e) {
                    PreferenceServiceRegistryHelper.log(PreferenceServiceRegistryHelper.createStatusError(PrefsMessages.preferences_classCastScope, e));
                    return new EclipsePreferences(parent, name);
                }
                catch (CoreException e) {
                    PreferenceServiceRegistryHelper.log(e.getStatus());
                    return new EclipsePreferences(parent, name);
                }
            } else if (((IConfigurationElement)value).getAttribute(ATTRIBUTE_STORAGE) != null) {
                try {
                    AbstractPreferenceStorage storage = (AbstractPreferenceStorage)((IConfigurationElement)value).createExecutableExtension(ATTRIBUTE_STORAGE);
                    ScopeDescriptor descriptor = new ScopeDescriptor(storage);
                    EclipsePreferences result = new EclipsePreferences(parent, name);
                    result.setDescriptor(descriptor);
                    return result;
                }
                catch (ClassCastException e) {
                    PreferenceServiceRegistryHelper.log(PreferenceServiceRegistryHelper.createStatusError(PrefsMessages.preferences_classCastStorage, e));
                    return new EclipsePreferences(parent, name);
                }
                catch (CoreException e) {
                    PreferenceServiceRegistryHelper.log(e.getStatus());
                    return new EclipsePreferences(parent, name);
                }
            }
        } else {
            scope = (IScope)value;
        }
        return scope.create(parent, name);
    }

    public ListenerList<PreferenceModifyListener> getModifyListeners() {
        if (this.modifyListeners == null) {
            this.modifyListeners = new ListenerList();
            IExtension[] extensions = this.getPrefExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (ELEMENT_MODIFIER.equalsIgnoreCase(elements[j].getName())) {
                        this.addModifyListener(elements[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this.modifyListeners;
    }

    private IExtension[] getPrefExtensions() {
        IExtensionPoint pointNew;
        IExtension[] extensionsOld = EMPTY_EXTENSION_ARRAY;
        IExtension[] extensionsNew = EMPTY_EXTENSION_ARRAY;
        IExtensionPoint pointOld = this.registry.getExtensionPoint("org.greenrobot.eclipse.core.runtime", "preferences");
        if (pointOld != null) {
            extensionsOld = pointOld.getExtensions();
        }
        if ((pointNew = this.registry.getExtensionPoint("org.greenrobot.eclipse.equinox.preferences", "preferences")) != null) {
            extensionsNew = pointNew.getExtensions();
        }
        IExtension[] extensions = new IExtension[extensionsOld.length + extensionsNew.length];
        System.arraycopy(extensionsOld, 0, extensions, 0, extensionsOld.length);
        System.arraycopy(extensionsNew, 0, extensions, extensionsOld.length, extensionsNew.length);
        if (extensions.length == 0 && EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("No extensions for org.eclipse.core.contenttype.");
        }
        return extensions;
    }

    private void initializeScopes() {
        IExtension[] extensions = this.getPrefExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (ELEMENT_SCOPE.equalsIgnoreCase(elements[j].getName())) {
                    this.scopeAdded(elements[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltasOld = event.getExtensionDeltas("org.greenrobot.eclipse.core.runtime", "preferences");
        IExtensionDelta[] deltasNew = event.getExtensionDeltas("org.greenrobot.eclipse.equinox.preferences", "preferences");
        IExtensionDelta[] deltas = new IExtensionDelta[deltasOld.length + deltasNew.length];
        System.arraycopy(deltasOld, 0, deltas, 0, deltasOld.length);
        System.arraycopy(deltasNew, 0, deltas, deltasOld.length, deltasNew.length);
        if (deltas.length == 0) {
            return;
        }
        int i = 0;
        while (i < deltas.length) {
            IConfigurationElement[] elements = deltas[i].getExtension().getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                switch (deltas[i].getKind()) {
                    case 1: {
                        if (!ELEMENT_SCOPE.equalsIgnoreCase(elements[j].getName())) break;
                        this.scopeAdded(elements[j]);
                        break;
                    }
                    case 2: {
                        String scope = elements[j].getAttribute(ATTRIBUTE_NAME);
                        if (scope == null) break;
                        this.scopeRemoved(scope);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.modifyListeners = null;
    }

    private void runInitializer(IConfigurationElement element) {
        try {
            final AbstractPreferenceInitializer initializer = (AbstractPreferenceInitializer)element.createExecutableExtension(ATTRIBUTE_CLASS);
            ISafeRunnable job = new ISafeRunnable(){

                @Override
                public void handleException(Throwable exception) {
                }

                @Override
                public void run() throws Exception {
                    initializer.initializeDefaultPreferences();
                }
            };
            SafeRunner.run(job);
        }
        catch (ClassCastException e) {
            Status status = new Status(4, "org.greenrobot.eclipse.equinox.preferences", 4, PrefsMessages.preferences_invalidExtensionSuperclass, e);
            PreferenceServiceRegistryHelper.log(status);
        }
        catch (CoreException e) {
            PreferenceServiceRegistryHelper.log(e.getStatus());
        }
    }

    private void scopeAdded(IConfigurationElement element) {
        String key = element.getAttribute(ATTRIBUTE_NAME);
        if (key == null) {
            String message = NLS.bind(PrefsMessages.preferences_missingScopeAttribute, element.getDeclaringExtension().getUniqueIdentifier());
            PreferenceServiceRegistryHelper.log(PreferenceServiceRegistryHelper.createStatusWarning(message, null));
            return;
        }
        scopeRegistry.put(key, element);
        ((RootPreferences)this.service.getRootNode()).addChild(key, null);
    }

    private void scopeRemoved(String key) {
        IEclipsePreferences node = (IEclipsePreferences)((RootPreferences)this.service.getRootNode()).getNode(key, false);
        if (node != null) {
            ((RootPreferences)this.service.getRootNode()).removeNode(node);
        } else {
            ((RootPreferences)this.service.getRootNode()).removeNode(key);
        }
        scopeRegistry.remove(key);
    }
}

