/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.resources;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import org.greenrobot.eclipse.core.internal.boot.PlatformURLConnection;
import org.greenrobot.eclipse.core.internal.boot.PlatformURLHandler;
import org.greenrobot.eclipse.core.internal.utils.Messages;
import org.greenrobot.eclipse.core.resources.IProject;
import org.greenrobot.eclipse.core.resources.IResource;
import org.greenrobot.eclipse.core.resources.ResourcesPlugin;
import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.core.runtime.Path;
import org.greenrobot.eclipse.osgi.util.NLS;

public class PlatformURLResourceConnection
extends PlatformURLConnection {
    public static final String RESOURCE = "resource";
    public static final String RESOURCE_URL_STRING = "platform:/resource/";
    private static URL rootURL;

    public PlatformURLResourceConnection(URL url) {
        super(url);
    }

    @Override
    protected boolean allowCaching() {
        return false;
    }

    @Override
    protected URL resolve() throws IOException {
        String filePath = this.url.getFile().trim();
        IPath spec = new Path(filePath = URLDecoder.decode(filePath, "UTF-8")).makeRelative();
        if (!spec.segment(0).equals(RESOURCE)) {
            throw new IOException(NLS.bind(Messages.url_badVariant, this.url));
        }
        int count = spec.segmentCount();
        if (count == 1) {
            return rootURL;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(spec.segment(1));
        if (!project.exists()) {
            String message = NLS.bind(Messages.url_couldNotResolve_projectDoesNotExist, project.getName(), this.url.toExternalForm());
            throw new IOException(message);
        }
        IResource resource = null;
        IPath result = null;
        if (count == 2) {
            resource = project;
        } else {
            spec = spec.removeFirstSegments(2);
            resource = project.getFile(spec);
        }
        result = resource.getLocation();
        if (result == null) {
            URI uri = resource.getLocationURI();
            if (uri != null) {
                try {
                    URL url2 = uri.toURL();
                    if (url2.getProtocol().equals("file")) {
                        return url2;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    String message = NLS.bind(Messages.url_couldNotResolve_URLProtocolHandlerCanNotResolveURL, uri.toString(), this.url.toExternalForm());
                    throw new IOException(message);
                }
            }
            String message = NLS.bind(Messages.url_couldNotResolve_resourceLocationCanNotBeDetermined, resource.getFullPath(), this.url.toExternalForm());
            throw new IOException(message);
        }
        return new URL("file", "", result.toString());
    }

    public static void startup(IPath root) {
        if (rootURL != null) {
            return;
        }
        try {
            rootURL = root.toFile().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        PlatformURLHandler.register(RESOURCE, PlatformURLResourceConnection.class);
    }
}

