/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.resources;

import org.greenrobot.eclipse.core.internal.resources.ICoreConstants;
import org.greenrobot.eclipse.core.internal.resources.ResourceInfo;
import org.greenrobot.eclipse.core.internal.resources.Workspace;
import org.greenrobot.eclipse.core.internal.watson.IPathRequestor;
import org.greenrobot.eclipse.core.resources.IResource;
import org.greenrobot.eclipse.core.resources.IResourceProxy;
import org.greenrobot.eclipse.core.resources.ResourcesPlugin;
import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.core.runtime.QualifiedName;

public class ResourceProxy
implements IResourceProxy,
ICoreConstants {
    protected final Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
    protected IPathRequestor requestor;
    protected ResourceInfo info;
    protected IPath fullPath;
    protected IResource resource;

    @Override
    public long getModificationStamp() {
        return this.info.getModificationStamp();
    }

    @Override
    public String getName() {
        return this.requestor.requestName();
    }

    @Override
    public Object getSessionProperty(QualifiedName key) {
        return this.info.getSessionProperty(key);
    }

    @Override
    public int getType() {
        return this.info.getType();
    }

    @Override
    public boolean isAccessible() {
        int flags = this.info.getFlags();
        if (this.info.getType() == 4) {
            return flags != -1 && ResourceInfo.isSet(flags, 1);
        }
        return flags != -1;
    }

    @Override
    public boolean isDerived() {
        int flags = this.info.getFlags();
        return flags != -1 && ResourceInfo.isSet(flags, 16384);
    }

    @Override
    public boolean isLinked() {
        int flags = this.info.getFlags();
        return flags != -1 && ResourceInfo.isSet(flags, 65536);
    }

    @Override
    public boolean isPhantom() {
        int flags = this.info.getFlags();
        return flags != -1 && ResourceInfo.isSet(flags, 8);
    }

    @Override
    public boolean isTeamPrivateMember() {
        int flags = this.info.getFlags();
        return flags != -1 && ResourceInfo.isSet(flags, 32768);
    }

    @Override
    public boolean isHidden() {
        int flags = this.info.getFlags();
        return flags != -1 && ResourceInfo.isSet(flags, 0x200000);
    }

    @Override
    public IPath requestFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.requestor.requestPath();
        }
        return this.fullPath;
    }

    @Override
    public IResource requestResource() {
        if (this.resource == null) {
            this.resource = this.workspace.newResource(this.requestFullPath(), this.info.getType());
        }
        return this.resource;
    }

    protected void reset() {
        this.fullPath = null;
        this.resource = null;
    }
}

