/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.greenrobot.eclipse.core.filesystem.EFS;
import org.greenrobot.eclipse.core.filesystem.IFileInfo;
import org.greenrobot.eclipse.core.filesystem.IFileStore;
import org.greenrobot.eclipse.core.filesystem.IFileSystem;
import org.greenrobot.eclipse.core.filesystem.URIUtil;
import org.greenrobot.eclipse.core.internal.resources.ResourceException;
import org.greenrobot.eclipse.core.internal.resources.Workspace;
import org.greenrobot.eclipse.core.internal.utils.Messages;
import org.greenrobot.eclipse.core.internal.utils.Policy;
import org.greenrobot.eclipse.core.resources.IFile;
import org.greenrobot.eclipse.core.resources.ResourceAttributes;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.core.runtime.IProgressMonitor;
import org.greenrobot.eclipse.core.runtime.Path;
import org.greenrobot.eclipse.core.runtime.Platform;
import org.greenrobot.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.greenrobot.eclipse.osgi.util.NLS;
import org.greenrobot.osgi.service.prefs.BackingStoreException;
import org.greenrobot.osgi.service.prefs.Preferences;

public class FileUtil {
    static final boolean MACOSX = "macosx".equals(FileUtil.getOS());

    public static IFileInfo attributesToFileInfo(ResourceAttributes attributes) {
        IFileInfo fileInfo = EFS.createFileInfo();
        fileInfo.setAttribute(2, attributes.isReadOnly());
        fileInfo.setAttribute(4, attributes.isExecutable());
        fileInfo.setAttribute(8, attributes.isArchive());
        fileInfo.setAttribute(16, attributes.isHidden());
        fileInfo.setAttribute(32, attributes.isSymbolicLink());
        fileInfo.setAttribute(0x2000000, attributes.isSet(0x2000000));
        fileInfo.setAttribute(0x4000000, attributes.isSet(0x4000000));
        fileInfo.setAttribute(0x8000000, attributes.isSet(0x8000000));
        fileInfo.setAttribute(0x10000000, attributes.isSet(0x10000000));
        fileInfo.setAttribute(0x20000000, attributes.isSet(0x20000000));
        fileInfo.setAttribute(0x40000000, attributes.isSet(0x40000000));
        return fileInfo;
    }

    public static IPath canonicalPath(IPath path) {
        if (path == null) {
            return null;
        }
        try {
            String pathString = path.toOSString();
            String canonicalPath = new File(pathString).getCanonicalPath();
            if (canonicalPath.equals(pathString)) {
                return path;
            }
            return new Path(canonicalPath);
        }
        catch (IOException iOException) {
            return path;
        }
    }

    public static IPath realPath(IPath path) {
        if (path == null) {
            return null;
        }
        IFileSystem fileSystem = EFS.getLocalFileSystem();
        if (fileSystem.isCaseSensitive()) {
            return path;
        }
        IPath realPath = path.isAbsolute() ? Path.ROOT : Path.EMPTY;
        String device = path.getDevice();
        if (device != null) {
            realPath = realPath.setDevice(device.toUpperCase());
        }
        IFileStore fileStore = null;
        int i = 0;
        while (i < path.segmentCount()) {
            final String segment = path.segment(i);
            if (i == 0 && path.isUNC()) {
                realPath = realPath.append(segment.toUpperCase());
                realPath = realPath.makeUNC(true);
            } else if (MACOSX) {
                String[] names = realPath.toFile().list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String n) {
                        return n.equalsIgnoreCase(segment);
                    }
                });
                if (names == null || names.length == 0) {
                    realPath = realPath.append(path.removeFirstSegments(realPath.segmentCount()));
                    break;
                }
                String realName = names.length == 1 ? names[0] : segment;
                realPath = realPath.append(realName);
            } else {
                IFileInfo info;
                if (fileStore == null) {
                    fileStore = fileSystem.getStore(realPath);
                }
                if (!(info = (fileStore = fileStore.getChild(segment)).fetchInfo()).exists()) {
                    realPath = realPath.append(path.removeFirstSegments(realPath.segmentCount()));
                    break;
                }
                realPath = realPath.append(info.getName());
            }
            ++i;
        }
        if (path.hasTrailingSeparator()) {
            realPath = realPath.addTrailingSeparator();
        }
        return realPath.equals(path) ? path : realPath;
    }

    private static String getOS() {
        return System.getProperty("osgi.os", "");
    }

    public static URI canonicalURI(URI uri) {
        if (uri == null) {
            return null;
        }
        if ("file".equals(uri.getScheme())) {
            IPath canonicalPath;
            IPath inputPath = URIUtil.toPath(uri);
            if (inputPath == (canonicalPath = FileUtil.canonicalPath(inputPath))) {
                return uri;
            }
            return URIUtil.toURI(canonicalPath);
        }
        return uri;
    }

    public static URI realURI(URI uri) {
        if (uri == null) {
            return null;
        }
        if ("file".equals(uri.getScheme())) {
            IPath realPath;
            IPath inputPath = URIUtil.toPath(uri);
            if (inputPath == (realPath = FileUtil.realPath(inputPath))) {
                return uri;
            }
            return URIUtil.toURI(realPath);
        }
        return uri;
    }

    private static boolean computeOverlap(IPath location1, IPath location2, boolean bothDirections) {
        IPath one = location1;
        IPath two = location2;
        if (!Workspace.caseSensitive) {
            one = new Path(location1.toOSString().toLowerCase());
            two = new Path(location2.toOSString().toLowerCase());
        }
        return one.isPrefixOf(two) || bothDirections && two.isPrefixOf(one);
    }

    private static boolean computeOverlap(URI location1, URI location2, boolean bothDirections) {
        IFileStore store2;
        if (location1.equals(location2)) {
            return true;
        }
        String scheme1 = location1.getScheme();
        String scheme2 = location2.getScheme();
        if (scheme1 == null ? scheme2 != null : !scheme1.equals(scheme2)) {
            return false;
        }
        if ("file".equals(scheme1) && "file".equals(scheme2)) {
            return FileUtil.computeOverlap(URIUtil.toPath(location1), URIUtil.toPath(location2), bothDirections);
        }
        IFileSystem system = null;
        try {
            system = EFS.getFileSystem(scheme1);
        }
        catch (CoreException coreException) {}
        if (system == null) {
            String string2;
            String string1 = location1.toString();
            return string1.startsWith(string2 = location2.toString()) || bothDirections && string2.startsWith(string1);
        }
        IFileStore store1 = system.getStore(location1);
        return store1.equals(store2 = system.getStore(location2)) || store1.isParentOf(store2) || bothDirections && store2.isParentOf(store1);
    }

    public static ResourceAttributes fileInfoToAttributes(IFileInfo fileInfo) {
        ResourceAttributes attributes = new ResourceAttributes();
        attributes.setReadOnly(fileInfo.getAttribute(2));
        attributes.setArchive(fileInfo.getAttribute(8));
        attributes.setExecutable(fileInfo.getAttribute(4));
        attributes.setHidden(fileInfo.getAttribute(16));
        attributes.setSymbolicLink(fileInfo.getAttribute(32));
        attributes.set(0x2000000, fileInfo.getAttribute(0x2000000));
        attributes.set(0x4000000, fileInfo.getAttribute(0x4000000));
        attributes.set(0x8000000, fileInfo.getAttribute(0x8000000));
        attributes.set(0x10000000, fileInfo.getAttribute(0x10000000));
        attributes.set(0x20000000, fileInfo.getAttribute(0x20000000));
        attributes.set(0x40000000, fileInfo.getAttribute(0x40000000));
        return attributes;
    }

    private static String getLineSeparatorFromPreferences(Preferences node) {
        try {
            if (node.nodeExists("org.greenrobot.eclipse.core.runtime")) {
                return node.node("org.greenrobot.eclipse.core.runtime").get("line.separator", null);
            }
        }
        catch (BackingStoreException backingStoreException) {}
        return null;
    }

    public static String getLineSeparator(IFile file) {
        if (file.exists()) {
            InputStream input = null;
            try {
                input = file.getContents();
                int c = input.read();
                while (c != -1 && c != 13 && c != 10) {
                    c = input.read();
                }
                if (c == 10) {
                    return "\n";
                }
                if (c == 13) {
                    if (input.read() == 10) {
                        return "\r\n";
                    }
                    return "\r";
                }
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {
            }
            finally {
                FileUtil.safeClose(input);
            }
        }
        IEclipsePreferences rootNode = Platform.getPreferencesService().getRootNode();
        String value = null;
        value = FileUtil.getLineSeparatorFromPreferences(rootNode.node("project").node(file.getProject().getName()));
        if (value != null) {
            return value;
        }
        value = FileUtil.getLineSeparatorFromPreferences(rootNode.node("instance"));
        if (value != null) {
            return value;
        }
        value = FileUtil.getLineSeparatorFromPreferences(rootNode.node("default"));
        if (value != null) {
            return value;
        }
        return System.getProperty("line.separator");
    }

    public static boolean isOverlapping(URI location1, URI location2) {
        return FileUtil.computeOverlap(location1, location2, true);
    }

    public static boolean isPrefixOf(IPath location1, IPath location2) {
        return FileUtil.computeOverlap(location1, location2, false);
    }

    public static boolean isPrefixOf(URI location1, URI location2) {
        return FileUtil.computeOverlap(location1, location2, false);
    }

    public static void safeClose(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static IPath toPath(URI uri) {
        if (uri == null) {
            return null;
        }
        String scheme = uri.getScheme();
        if (scheme == null || "file".equals(scheme)) {
            return new Path(uri.getSchemeSpecificPart());
        }
        return null;
    }

    public static final void transferStreams(InputStream source, OutputStream destination, String path, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            byte[] buffer = new byte[8192];
            while (true) {
                int bytesRead = -1;
                try {
                    bytesRead = source.read(buffer);
                }
                catch (IOException e) {
                    String msg = NLS.bind(Messages.localstore_failedReadDuringWrite, path);
                    throw new ResourceException(271, new Path(path), msg, e);
                }
                try {
                    if (bytesRead == -1) {
                        destination.close();
                        break;
                    }
                    destination.write(buffer, 0, bytesRead);
                }
                catch (IOException e) {
                    String msg = NLS.bind(Messages.localstore_couldNotWrite, path);
                    throw new ResourceException(272, new Path(path), msg, e);
                }
                monitor.worked(1);
            }
        }
        finally {
            FileUtil.safeClose(source);
            FileUtil.safeClose(destination);
        }
    }

    private FileUtil() {
    }
}

