/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.resources;

import org.greenrobot.eclipse.core.internal.preferences.AbstractScope;
import org.greenrobot.eclipse.core.resources.IProject;
import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.core.runtime.Platform;
import org.greenrobot.eclipse.core.runtime.preferences.IEclipsePreferences;

public final class ProjectScope
extends AbstractScope {
    public static final String SCOPE = "project";
    private IProject context;

    public ProjectScope(IProject context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.context = context;
    }

    @Override
    public IEclipsePreferences getNode(String qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException();
        }
        return (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node(SCOPE).node(this.context.getName()).node(qualifier);
    }

    @Override
    public IPath getLocation() {
        IProject project = this.context.getProject();
        IPath location = project.getLocation();
        return location == null ? null : location.append(".settings");
    }

    @Override
    public String getName() {
        return SCOPE;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ProjectScope)) {
            return false;
        }
        ProjectScope other = (ProjectScope)obj;
        return this.context.equals(other.context);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.context.getFullPath().hashCode();
    }
}

