/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.runtime.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.greenrobot.eclipse.core.internal.content.ContentMessages;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IConfigurationElement;
import org.greenrobot.eclipse.core.runtime.IExecutableExtension;
import org.greenrobot.eclipse.core.runtime.Status;
import org.greenrobot.eclipse.core.runtime.content.IContentDescription;
import org.greenrobot.eclipse.core.runtime.content.XMLContentDescriber;
import org.greenrobot.eclipse.core.runtime.content.XMLRootElementContentDescriber2;
import org.greenrobot.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;

public final class XMLRootElementContentDescriber
extends XMLContentDescriber
implements IExecutableExtension {
    private static final String DTD_TO_FIND = "dtd";
    private static final String ELEMENT_TO_FIND = "element";
    private String dtdToFind = null;
    private String elementToFind = null;

    private int checkCriteria(InputSource contents, Map<String, Object> properties) throws IOException {
        if (!XMLRootElementContentDescriber2.isProcessed(properties)) {
            XMLRootElementContentDescriber2.fillContentProperties(contents, properties);
        }
        return this.checkCriteria(properties);
    }

    private int checkCriteria(Map<String, Object> properties) throws IOException {
        Boolean result = (Boolean)properties.get("org.greenrobot.eclipse.core.runtime.content.XMLRootElementContentDescriber2.result");
        if (!result.booleanValue()) {
            return 1;
        }
        if (this.dtdToFind != null && !this.dtdToFind.equals(properties.get("org.greenrobot.eclipse.core.runtime.content.XMLRootElementContentDescriber2.dtd"))) {
            return 1;
        }
        if (this.elementToFind != null && !this.elementToFind.equals(properties.get("org.greenrobot.eclipse.core.runtime.content.XMLRootElementContentDescriber2.element"))) {
            return 1;
        }
        return 2;
    }

    @Override
    public int describe(InputStream contents, IContentDescription description) throws IOException {
        return this.describe(contents, description, new HashMap<String, Object>());
    }

    public int describe(InputStream contents, IContentDescription description, Map<String, Object> properties) throws IOException {
        if (super.describe2(contents, description, properties) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents), properties);
    }

    @Override
    public int describe(Reader contents, IContentDescription description) throws IOException {
        return this.describe(contents, description, new HashMap<String, Object>());
    }

    public int describe(Reader contents, IContentDescription description, Map<String, Object> properties) throws IOException {
        if (super.describe2(contents, description, properties) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents), properties);
    }

    @Override
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.elementToFind = (String)data;
        } else if (data instanceof Hashtable) {
            Hashtable parameters = (Hashtable)data;
            this.dtdToFind = (String)parameters.get(DTD_TO_FIND);
            this.elementToFind = (String)parameters.get(ELEMENT_TO_FIND);
        }
        if (this.dtdToFind == null && this.elementToFind == null) {
            String message = NLS.bind(ContentMessages.content_badInitializationData, XMLRootElementContentDescriber.class.getName());
            throw new CoreException(new Status(4, "org.greenrobot.eclipse.core.contenttype", 0, message, null));
        }
    }
}

