/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core;

import org.greenrobot.eclipse.core.resources.ResourcesPlugin;
import org.greenrobot.eclipse.core.runtime.jobs.ISchedulingRule;
import org.greenrobot.eclipse.jdt.core.IJavaElement;
import org.greenrobot.eclipse.jdt.core.JavaModelException;
import org.greenrobot.eclipse.jdt.internal.core.ClasspathChange;
import org.greenrobot.eclipse.jdt.internal.core.ClasspathValidation;
import org.greenrobot.eclipse.jdt.internal.core.DeltaProcessingState;
import org.greenrobot.eclipse.jdt.internal.core.ExternalFolderChange;
import org.greenrobot.eclipse.jdt.internal.core.JavaElementDelta;
import org.greenrobot.eclipse.jdt.internal.core.JavaModelManager;
import org.greenrobot.eclipse.jdt.internal.core.JavaModelOperation;
import org.greenrobot.eclipse.jdt.internal.core.JavaProject;
import org.greenrobot.eclipse.jdt.internal.core.ProjectReferenceChange;

public abstract class ChangeClasspathOperation
extends JavaModelOperation {
    protected boolean canChangeResources;

    public ChangeClasspathOperation(IJavaElement[] elements, boolean canChangeResources) {
        super(elements);
        this.canChangeResources = canChangeResources;
    }

    @Override
    protected boolean canModifyRoots() {
        return true;
    }

    protected void classpathChanged(ClasspathChange change, boolean refreshExternalFolder) throws JavaModelException {
        JavaProject project = change.project;
        project.resetCaches();
        if (this.canChangeResources) {
            if (this.isTopLevelOperation() && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
                new ClasspathValidation(project).validate();
            }
            new ProjectReferenceChange(project, change.oldResolvedClasspath).updateProjectReferencesIfNecessary();
            new ExternalFolderChange(project, change.oldResolvedClasspath).updateExternalFoldersIfNecessary(refreshExternalFolder, null);
        } else {
            DeltaProcessingState state = JavaModelManager.getDeltaState();
            JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
            int result = change.generateDelta(delta, true);
            if ((result & 1) != 0) {
                this.addDelta(delta);
                state.rootsAreStale = true;
                change.requestIndexing();
                state.addClasspathValidation(project);
            }
            if ((result & 2) != 0) {
                state.addProjectReferenceChange(project, change.oldResolvedClasspath);
            }
            if ((result & 4) != 0) {
                state.addExternalFolderChange(project, change.oldResolvedClasspath);
            }
        }
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return !this.canChangeResources;
    }
}

