/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.dom;

import java.util.List;
import org.greenrobot.eclipse.jdt.core.dom.ASTNode;
import org.greenrobot.eclipse.jdt.core.dom.ASTVisitor;
import org.greenrobot.eclipse.jdt.core.dom.ArrayCreation;
import org.greenrobot.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

public class SourceRangeVerifier
extends ASTVisitor {
    public static boolean DEBUG = false;
    public static boolean DEBUG_THROW = false;
    private StringBuffer bugs;

    public String process(ASTNode node) {
        StringBuffer buffer;
        this.bugs = buffer = new StringBuffer();
        node.accept(this);
        this.bugs = null;
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean preVisit2(ASTNode node) {
        ASTNode previous = null;
        List properties = node.structuralPropertiesForType();
        int i = 0;
        while (i < properties.size()) {
            StructuralPropertyDescriptor property = (StructuralPropertyDescriptor)properties.get(i);
            if (property.isChildProperty()) {
                ASTNode child = (ASTNode)node.getStructuralProperty(property);
                if (child != null) {
                    boolean ok = this.checkChild(node, previous, child);
                    if (!ok) return false;
                    previous = child;
                }
            } else if (property.isChildListProperty()) {
                List children = (List)node.getStructuralProperty(property);
                int j = 0;
                while (j < children.size()) {
                    ASTNode child = (ASTNode)children.get(j);
                    boolean ok = this.checkChild(node, previous, child);
                    if (!ok) {
                        return false;
                    }
                    previous = child;
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean checkChild(ASTNode parent, ASTNode previous, ASTNode child) {
        if ((parent.getFlags() & 9) != 0 || (child.getFlags() & 9) != 0) {
            return false;
        }
        int parentStart = parent.getStartPosition();
        int parentEnd = parentStart + parent.getLength();
        int childStart = child.getStartPosition();
        int childEnd = childStart + child.getLength();
        if (previous != null) {
            if (child.getLocationInParent() == ArrayCreation.DIMENSIONS_PROPERTY) {
                return false;
            }
            int previousStart = previous.getStartPosition();
            int previousEnd = previousStart + previous.getLength();
            if (childStart < previousEnd) {
                String bug = "- parent [" + parentStart + ", " + parentEnd + "] " + parent.getClass().getName() + '\n' + "   previous [" + previousStart + ", " + previousEnd + "] " + previous.getClass().getName() + '\n' + "   " + child.getLocationInParent().getId() + " [" + childStart + ", " + childEnd + "] " + child.getClass().getName() + '\n';
                this.bugs.append(bug);
            }
        }
        if (parentStart > childStart || childEnd > parentEnd) {
            String bug = "- parent [" + parentStart + ", " + parentEnd + "] " + parent.getClass().getName() + '\n' + "   " + child.getLocationInParent().getId() + " [" + childStart + ", " + childEnd + "] " + child.getClass().getName() + '\n';
            this.bugs.append(bug);
        }
        return true;
    }
}

