/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.search;

import org.greenrobot.eclipse.core.runtime.Path;
import org.greenrobot.eclipse.jdt.core.IClassFile;
import org.greenrobot.eclipse.jdt.core.ICompilationUnit;
import org.greenrobot.eclipse.jdt.core.IJavaProject;
import org.greenrobot.eclipse.jdt.core.IPackageFragment;
import org.greenrobot.eclipse.jdt.core.IPackageFragmentRoot;
import org.greenrobot.eclipse.jdt.core.IType;
import org.greenrobot.eclipse.jdt.core.JavaModelException;
import org.greenrobot.eclipse.jdt.core.compiler.CharOperation;
import org.greenrobot.eclipse.jdt.core.search.IJavaSearchScope;
import org.greenrobot.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.greenrobot.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.greenrobot.eclipse.jdt.internal.core.Openable;
import org.greenrobot.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.greenrobot.eclipse.jdt.internal.core.search.AbstractJavaSearchScope;
import org.greenrobot.eclipse.jdt.internal.core.util.HandleFactory;
import org.greenrobot.eclipse.jdt.internal.core.util.HashtableOfArrayToObject;
import org.greenrobot.eclipse.jdt.internal.core.util.Util;

public abstract class NameMatchRequestorWrapper {
    protected IJavaSearchScope scope;
    private HandleFactory handleFactory;
    private String lastPkgFragmentRootPath;
    private IPackageFragmentRoot lastPkgFragmentRoot;
    private HashtableOfArrayToObject packageHandles;
    private Object lastProject;
    private long complianceValue;

    public NameMatchRequestorWrapper(IJavaSearchScope scope) {
        this.scope = scope;
        if (!(scope instanceof AbstractJavaSearchScope)) {
            this.handleFactory = new HandleFactory();
        }
    }

    public IType getType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
        IType type = null;
        try {
            if (this.handleFactory != null) {
                Openable openable = this.handleFactory.createOpenable(path, this.scope);
                if (openable == null) {
                    return type;
                }
                switch (openable.getElementType()) {
                    case 5: {
                        ICompilationUnit cu = (ICompilationUnit)((Object)openable);
                        if (enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                            type = cu.getType(new String(enclosingTypeNames[0]));
                            int j = 1;
                            int l = enclosingTypeNames.length;
                            while (j < l) {
                                type = type.getType(new String(enclosingTypeNames[j]));
                                ++j;
                            }
                            type = type.getType(new String(simpleTypeName));
                            break;
                        }
                        type = cu.getType(new String(simpleTypeName));
                        break;
                    }
                    case 6: {
                        type = ((IClassFile)((Object)openable)).getType();
                    }
                }
            } else {
                int separatorIndex = path.indexOf("|");
                type = separatorIndex == -1 ? this.createTypeFromPath(path, new String(simpleTypeName), enclosingTypeNames) : this.createTypeFromJar(path, separatorIndex);
            }
        }
        catch (JavaModelException javaModelException) {}
        return type;
    }

    private IType createTypeFromJar(String resourcePath, int separatorIndex) throws JavaModelException {
        Object[] pkgName;
        String classFilePath;
        String[] simpleNames;
        int length;
        if (this.lastPkgFragmentRootPath == null || this.lastPkgFragmentRootPath.length() > resourcePath.length() || !resourcePath.startsWith(this.lastPkgFragmentRootPath)) {
            String jarPath = resourcePath.substring(0, separatorIndex);
            IPackageFragmentRoot root = ((AbstractJavaSearchScope)this.scope).packageFragmentRoot(resourcePath, separatorIndex, jarPath);
            if (root == null) {
                return null;
            }
            this.lastPkgFragmentRootPath = jarPath;
            this.lastPkgFragmentRoot = root;
            this.packageHandles = new HashtableOfArrayToObject(5);
        }
        if ((length = (simpleNames = new Path(classFilePath = resourcePath.substring(separatorIndex + 1)).segments()).length - 1) > 0) {
            pkgName = new String[length];
            System.arraycopy(simpleNames, 0, pkgName, 0, length);
        } else {
            pkgName = CharOperation.NO_STRINGS;
        }
        IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName);
        if (pkgFragment == null) {
            pkgFragment = ((PackageFragmentRoot)this.lastPkgFragmentRoot).getPackageFragment((String[])pkgName);
            if (length == 5 && ((String)pkgName[4]).equals("enum")) {
                IJavaProject proj = (IJavaProject)pkgFragment.getAncestor(2);
                if (!proj.equals(this.lastProject)) {
                    String complianceStr = proj.getOption("org.greenrobot.eclipse.jdt.core.compiler.source", true);
                    this.complianceValue = CompilerOptions.versionToJdkLevel(complianceStr);
                    this.lastProject = proj;
                }
                if (this.complianceValue >= 0x310000L) {
                    return null;
                }
            }
            this.packageHandles.put(pkgName, pkgFragment);
        }
        return pkgFragment.getClassFile(simpleNames[length]).getType();
    }

    private IType createTypeFromPath(String resourcePath, String simpleTypeName, char[][] enclosingTypeNames) throws JavaModelException {
        String simpleName;
        Object[] pkgName;
        String[] simpleNames;
        int length;
        int rootPathLength = -1;
        if (this.lastPkgFragmentRootPath == null || !resourcePath.startsWith(this.lastPkgFragmentRootPath) || (rootPathLength = this.lastPkgFragmentRootPath.length()) <= 0 || resourcePath.charAt(rootPathLength) != '/') {
            PackageFragmentRoot root = (PackageFragmentRoot)((AbstractJavaSearchScope)this.scope).packageFragmentRoot(resourcePath, -1, null);
            if (root == null) {
                return null;
            }
            this.lastPkgFragmentRoot = root;
            this.lastPkgFragmentRootPath = root.internalPath().toString();
            this.packageHandles = new HashtableOfArrayToObject(5);
        }
        if ((length = (simpleNames = new Path(resourcePath = resourcePath.substring(this.lastPkgFragmentRootPath.length() + 1)).segments()).length - 1) > 0) {
            pkgName = new String[length];
            System.arraycopy(simpleNames, 0, pkgName, 0, length);
        } else {
            pkgName = CharOperation.NO_STRINGS;
        }
        IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName);
        if (pkgFragment == null) {
            pkgFragment = ((PackageFragmentRoot)this.lastPkgFragmentRoot).getPackageFragment((String[])pkgName);
            this.packageHandles.put(pkgName, pkgFragment);
        }
        if (Util.isJavaLikeFileName(simpleName = simpleNames[length])) {
            IType type;
            ICompilationUnit unit = pkgFragment.getCompilationUnit(simpleName);
            int etnLength = enclosingTypeNames == null ? 0 : enclosingTypeNames.length;
            IType iType = type = etnLength == 0 ? unit.getType(simpleTypeName) : unit.getType(new String(enclosingTypeNames[0]));
            if (etnLength > 0) {
                int i = 1;
                while (i < etnLength) {
                    type = type.getType(new String(enclosingTypeNames[i]));
                    ++i;
                }
                type = type.getType(simpleTypeName);
            }
            return type;
        }
        if (org.greenrobot.eclipse.jdt.internal.compiler.util.Util.isClassFileName(simpleName)) {
            IClassFile classFile = pkgFragment.getClassFile(simpleName);
            return classFile.getType();
        }
        return null;
    }
}

