/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.search.indexing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipFile;
import org.greenrobot.eclipse.core.resources.IFile;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.core.runtime.IProgressMonitor;
import org.greenrobot.eclipse.core.runtime.Path;
import org.greenrobot.eclipse.jdt.core.compiler.InvalidInputException;
import org.greenrobot.eclipse.jdt.core.search.SearchEngine;
import org.greenrobot.eclipse.jdt.core.search.SearchParticipant;
import org.greenrobot.eclipse.jdt.internal.compiler.parser.Scanner;
import org.greenrobot.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.greenrobot.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.greenrobot.eclipse.jdt.internal.core.JavaModelManager;
import org.greenrobot.eclipse.jdt.internal.core.index.Index;
import org.greenrobot.eclipse.jdt.internal.core.index.IndexLocation;
import org.greenrobot.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.greenrobot.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.greenrobot.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.greenrobot.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.greenrobot.eclipse.jdt.internal.core.search.processing.JobManager;
import org.greenrobot.eclipse.jdt.internal.core.util.Util;

class AddJarFileToIndex
extends IndexRequest {
    private static final char JAR_SEPARATOR = "|".charAt(0);
    IFile resource;
    Scanner scanner;
    private IndexLocation indexFileURL;
    private final boolean forceIndexUpdate;

    public AddJarFileToIndex(IFile resource, IndexLocation indexFile, IndexManager manager) {
        this(resource, indexFile, manager, false);
    }

    public AddJarFileToIndex(IFile resource, IndexLocation indexFile, IndexManager manager, boolean updateIndex) {
        super(resource.getFullPath(), manager);
        this.resource = resource;
        this.indexFileURL = indexFile;
        this.forceIndexUpdate = updateIndex;
    }

    public AddJarFileToIndex(IPath jarPath, IndexLocation indexFile, IndexManager manager) {
        this(jarPath, indexFile, manager, false);
    }

    public AddJarFileToIndex(IPath jarPath, IndexLocation indexFile, IndexManager manager, boolean updateIndex) {
        super(jarPath, manager);
        this.indexFileURL = indexFile;
        this.forceIndexUpdate = updateIndex;
    }

    public boolean equals(Object o) {
        if (o instanceof AddJarFileToIndex) {
            if (this.resource != null) {
                return this.resource.equals(((AddJarFileToIndex)o).resource);
            }
            if (this.containerPath != null) {
                return this.containerPath.equals(((AddJarFileToIndex)o).containerPath);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.resource != null) {
            return this.resource.hashCode();
        }
        if (this.containerPath != null) {
            return this.containerPath.hashCode();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (this.hasPreBuiltIndex()) {
            boolean added = this.manager.addIndex(this.containerPath, this.indexFileURL);
            if (added) {
                return true;
            }
            this.indexFileURL = null;
        }
        try {
            Index index = this.manager.getIndexForUpdate(this.containerPath, false, false);
            if (index != null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> no indexing required (index already exists) for " + this.containerPath);
                return true;
            }
            index = this.manager.getIndexForUpdate(this.containerPath, true, true);
            if (index == null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> index could not be created for " + this.containerPath);
                return true;
            }
            ReadWriteMonitor monitor = index.monitor;
            if (monitor == null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> index for " + this.containerPath + " just got deleted");
                return true;
            }
            index.separator = JAR_SEPARATOR;
            ZipFile zip = null;
            try {
                Path zipFilePath = null;
                monitor.enterWrite();
                if (this.resource != null) {
                    File file;
                    URI location;
                    block46: {
                        location = this.resource.getLocationURI();
                        if (location == null) {
                            return false;
                        }
                        if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                            System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + location.getPath());
                        }
                        file = null;
                        try {
                            file = Util.toLocalFile(location, progressMonitor);
                        }
                        catch (CoreException e) {
                            if (!JobManager.VERBOSE) break block46;
                            Util.verbose("-> failed to index " + location.getPath() + " because of the following exception:");
                            e.printStackTrace();
                        }
                    }
                    if (file == null) {
                        if (!JobManager.VERBOSE) return false;
                        Util.verbose("-> failed to index " + location.getPath() + " because the file could not be fetched");
                        return false;
                    }
                    zip = new ZipFile(file);
                    zipFilePath = (Path)this.resource.getFullPath().makeRelative();
                } else {
                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + this.containerPath);
                    }
                    zip = new ZipFile(this.containerPath.toFile());
                    zipFilePath = (Path)this.containerPath;
                }
                if (this.isCancelled) {
                    if (!JobManager.VERBOSE) return false;
                    Util.verbose("-> indexing of " + zip.getName() + " has been cancelled");
                    return false;
                }
                if (JobManager.VERBOSE) {
                    Util.verbose("-> indexing " + zip.getName());
                }
                long initialTime = System.currentTimeMillis();
                String[] paths = index.queryDocumentNames("");
                if (paths != null) {
                    boolean needToReindex;
                    int max = paths.length;
                    String EXISTS = "OK";
                    String DELETED = "DELETED";
                    SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                    int i = 0;
                    while (i < max) {
                        indexedFileNames.put(paths[i], DELETED);
                        ++i;
                    }
                    Enumeration<? extends ZipEntry> e = zip.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry ze = e.nextElement();
                        String zipEntryName = ze.getName();
                        if (!org.greenrobot.eclipse.jdt.internal.compiler.util.Util.isClassFileName(zipEntryName) || !this.isValidPackageNameForClass(zipEntryName)) continue;
                        indexedFileNames.put(zipEntryName, EXISTS);
                    }
                    boolean bl = needToReindex = indexedFileNames.elementSize != max;
                    if (!needToReindex) {
                        Object[] valueTable = indexedFileNames.valueTable;
                        int i2 = 0;
                        int l = valueTable.length;
                        while (i2 < l) {
                            if (valueTable[i2] == DELETED) {
                                needToReindex = true;
                                break;
                            }
                            ++i2;
                        }
                        if (!needToReindex) {
                            if (JobManager.VERBOSE) {
                                Util.verbose("-> no indexing required (index is consistent with library) for " + zip.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                            }
                            this.manager.saveIndex(index);
                            return true;
                        }
                    }
                }
                SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
                if (!this.manager.resetIndex(this.containerPath)) {
                    this.manager.removeIndex(this.containerPath);
                    return false;
                }
                index.separator = JAR_SEPARATOR;
                Path indexPath = null;
                IndexLocation indexLocation = index.getIndexLocation();
                if (indexLocation != null) {
                    indexPath = new Path(indexLocation.getCanonicalFilePath());
                }
                Enumeration<? extends ZipEntry> e = zip.entries();
                while (e.hasMoreElements()) {
                    if (this.isCancelled) {
                        if (!JobManager.VERBOSE) return false;
                        Util.verbose("-> indexing of " + zip.getName() + " has been cancelled");
                        return false;
                    }
                    ZipEntry ze = e.nextElement();
                    String zipEntryName = ze.getName();
                    if (!org.greenrobot.eclipse.jdt.internal.compiler.util.Util.isClassFileName(zipEntryName) || !this.isValidPackageNameForClass(zipEntryName)) continue;
                    byte[] classFileBytes = org.greenrobot.eclipse.jdt.internal.compiler.util.Util.getZipEntryByteContent(ze, zip);
                    JavaSearchDocument entryDocument = new JavaSearchDocument(ze, zipFilePath, classFileBytes, participant);
                    this.manager.indexDocument(entryDocument, participant, index, indexPath);
                }
                if (this.forceIndexUpdate) {
                    this.manager.savePreBuiltIndex(index);
                } else {
                    this.manager.saveIndex(index);
                }
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> done indexing of " + zip.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                return true;
            }
            finally {
                if (zip != null) {
                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zip);
                    }
                    zip.close();
                }
                monitor.exitWrite();
            }
        }
        catch (IOException e) {
            if (JobManager.VERBOSE) {
                Util.verbose("-> failed to index " + this.containerPath + " because of the following exception:");
                e.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            return false;
        }
        catch (ZipError e) {
            if (JobManager.VERBOSE) {
                Util.verbose("-> failed to index " + this.containerPath + " because of the following exception:");
                e.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            return false;
        }
    }

    @Override
    public String getJobFamily() {
        if (this.resource != null) {
            return super.getJobFamily();
        }
        return this.containerPath.toOSString();
    }

    private boolean isIdentifier() throws InvalidInputException {
        switch (this.scanner.scanIdentifier()) {
            case 22: 
            case 69: 
            case 72: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidPackageNameForClass(String className) {
        char[] classNameArray = className.toCharArray();
        if (this.scanner == null) {
            this.scanner = new Scanner(false, true, false, 0x330000L, null, null, true);
        }
        this.scanner.setSource(classNameArray);
        this.scanner.eofPosition = classNameArray.length - SuffixConstants.SUFFIX_CLASS.length;
        try {
            if (!this.isIdentifier()) return false;
            do {
                if (this.scanner.eofPosition <= this.scanner.currentPosition) {
                    return true;
                }
                if (this.scanner.getNextChar() == 47 && this.scanner.eofPosition > this.scanner.currentPosition) continue;
                return false;
            } while (this.isIdentifier());
            return false;
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    @Override
    protected Integer updatedIndexState() {
        Integer updateState = null;
        updateState = this.hasPreBuiltIndex() ? IndexManager.REUSE_STATE : IndexManager.REBUILDING_STATE;
        return updateState;
    }

    public String toString() {
        return "indexing " + this.containerPath.toString();
    }

    protected boolean hasPreBuiltIndex() {
        return !this.forceIndexUpdate && this.indexFileURL != null && this.indexFileURL.exists();
    }
}

