/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.search.indexing;

import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.greenrobot.eclipse.jdt.internal.core.search.processing.IJob;

public abstract class IndexRequest
implements IJob {
    protected boolean isCancelled = false;
    protected IPath containerPath;
    protected IndexManager manager;

    public IndexRequest(IPath containerPath, IndexManager manager) {
        this.containerPath = containerPath;
        this.manager = manager;
    }

    @Override
    public boolean belongsTo(String projectNameOrJarPath) {
        return projectNameOrJarPath.equals(this.containerPath.segment(0)) || projectNameOrJarPath.equals(this.containerPath.toString());
    }

    @Override
    public void cancel() {
        this.manager.jobWasCancelled(this.containerPath);
        this.isCancelled = true;
    }

    @Override
    public void ensureReadyToRun() {
        this.manager.aboutToUpdateIndex(this.containerPath, this.updatedIndexState());
    }

    @Override
    public String getJobFamily() {
        return this.containerPath.toString();
    }

    protected Integer updatedIndexState() {
        return IndexManager.UPDATING_STATE;
    }
}

