/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.search.indexing;

import org.greenrobot.eclipse.core.resources.IProject;
import org.greenrobot.eclipse.core.resources.ResourcesPlugin;
import org.greenrobot.eclipse.core.runtime.Path;
import org.greenrobot.eclipse.jdt.core.IType;
import org.greenrobot.eclipse.jdt.core.JavaCore;
import org.greenrobot.eclipse.jdt.core.compiler.CharOperation;
import org.greenrobot.eclipse.jdt.core.search.SearchDocument;
import org.greenrobot.eclipse.jdt.internal.compiler.CompilationResult;
import org.greenrobot.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.greenrobot.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.greenrobot.eclipse.jdt.internal.compiler.SourceElementParser;
import org.greenrobot.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.greenrobot.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.greenrobot.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.greenrobot.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.greenrobot.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.greenrobot.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.greenrobot.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.greenrobot.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.greenrobot.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.greenrobot.eclipse.jdt.internal.compiler.env.ISourceType;
import org.greenrobot.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.greenrobot.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.greenrobot.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.greenrobot.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.greenrobot.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.greenrobot.eclipse.jdt.internal.compiler.parser.Parser;
import org.greenrobot.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.greenrobot.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.greenrobot.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.greenrobot.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.greenrobot.eclipse.jdt.internal.core.JavaModel;
import org.greenrobot.eclipse.jdt.internal.core.JavaModelManager;
import org.greenrobot.eclipse.jdt.internal.core.JavaProject;
import org.greenrobot.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.greenrobot.eclipse.jdt.internal.core.jdom.CompilationUnit;
import org.greenrobot.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.greenrobot.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.greenrobot.eclipse.jdt.internal.core.search.indexing.SourceIndexerRequestor;
import org.greenrobot.eclipse.jdt.internal.core.search.matching.JavaSearchNameEnvironment;
import org.greenrobot.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.greenrobot.eclipse.jdt.internal.core.search.processing.JobManager;

public class SourceIndexer
extends AbstractIndexer
implements ITypeRequestor,
SuffixConstants {
    private LookupEnvironment lookupEnvironment;
    private CompilerOptions options;
    public ISourceElementRequestor requestor = new SourceIndexerRequestor(this);
    private Parser basicParser;
    private CompilationUnit compilationUnit;
    private CompilationUnitDeclaration cud;
    private static final boolean DEBUG = false;

    public SourceIndexer(SearchDocument document) {
        super(document);
    }

    @Override
    public void indexDocument() {
        block8: {
            String documentPath = this.document.getPath();
            SourceElementParser parser = this.document.getParser();
            if (parser == null) {
                Path path = new Path(documentPath);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                parser = JavaModelManager.getJavaModelManager().indexManager.getSourceElementParser(JavaCore.create(project), this.requestor);
            } else {
                parser.setRequestor(this.requestor);
            }
            char[] source = null;
            char[] name = null;
            try {
                source = this.document.getCharContents();
                name = documentPath.toCharArray();
            }
            catch (Exception exception) {}
            if (source == null || name == null) {
                return;
            }
            this.compilationUnit = new CompilationUnit(source, name);
            try {
                if (parser.parseCompilationUnit(this.compilationUnit, true, null).hasFunctionalTypes()) {
                    this.document.requireIndexingResolvedDocument();
                }
            }
            catch (Exception e) {
                if (!JobManager.VERBOSE) break block8;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding, accessRestriction);
    }

    @Override
    public void accept(ICompilationUnit unit, AccessRestriction accessRestriction) {
        CompilationResult unitResult = new CompilationResult(unit, 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration parsedUnit = this.basicParser.dietParse(unit, unitResult);
        this.lookupEnvironment.buildTypeBindings(parsedUnit, accessRestriction);
        this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
    }

    @Override
    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)sourceType;
        IType type = elementInfo.getHandle();
        ICompilationUnit sourceUnit = (ICompilationUnit)((Object)type.getCompilationUnit());
        this.accept(sourceUnit, accessRestriction);
    }

    public void resolveDocument() {
        block2: {
            try {
                Path path = new Path(this.document.getPath());
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
                JavaProject javaProject = (JavaProject)model.getJavaProject(project);
                this.options = new CompilerOptions(javaProject.getOptions(true));
                ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
                this.basicParser = new Parser(problemReporter, false);
                this.basicParser.reportOnlyOneSyntaxError = true;
                this.basicParser.scanner.taskTags = null;
                this.cud = this.basicParser.parse(this.compilationUnit, new CompilationResult(this.compilationUnit, 0, 0, this.options.maxProblemsPerUnit));
                JavaSearchNameEnvironment nameEnvironment = new JavaSearchNameEnvironment(javaProject, JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, true));
                this.lookupEnvironment = new LookupEnvironment(this, this.options, problemReporter, nameEnvironment);
                this.reduceParseTree(this.cud);
                this.lookupEnvironment.buildTypeBindings(this.cud, null);
                this.lookupEnvironment.completeTypeBindings();
                this.cud.scope.faultInTypes();
                this.cud.resolve();
            }
            catch (Exception e) {
                if (!JobManager.VERBOSE) break block2;
                e.printStackTrace();
            }
        }
    }

    private void reduceParseTree(CompilationUnitDeclaration unit) {
        TypeDeclaration[] types = unit.types;
        int i = 0;
        int l = types == null ? 0 : types.length;
        while (i < l) {
            this.purgeMethodStatements(types[i]);
            ++i;
        }
    }

    private void purgeMethodStatements(TypeDeclaration type) {
        AbstractMethodDeclaration[] methods = type.methods;
        int j = 0;
        int length = methods == null ? 0 : methods.length;
        while (j < length) {
            AbstractMethodDeclaration method = methods[j];
            if (method != null && (method.bits & 0x200000) == 0) {
                method.statements = null;
                method.javadoc = null;
            }
            ++j;
        }
        TypeDeclaration[] memberTypes = type.memberTypes;
        if (memberTypes != null) {
            int i = 0;
            int l = memberTypes.length;
            while (i < l) {
                this.purgeMethodStatements(memberTypes[i]);
                ++i;
            }
        }
    }

    @Override
    public void indexResolvedDocument() {
        block9: {
            try {
                int i = 0;
                int length = this.cud.functionalExpressionsCount;
                while (i < length) {
                    FunctionalExpression expression = this.cud.functionalExpressions[i];
                    if (expression instanceof LambdaExpression) {
                        LambdaExpression lambdaExpression = (LambdaExpression)expression;
                        if (lambdaExpression.binding != null && lambdaExpression.binding.isValidBinding()) {
                            char[] superinterface = lambdaExpression.resolvedType.sourceName();
                            this.addIndexEntry(IIndexConstants.METHOD_DECL, MethodPattern.createIndexKey(lambdaExpression.descriptor.selector, lambdaExpression.descriptor.parameters.length));
                            this.addClassDeclaration(0, CharOperation.NO_CHAR, ONE_ZERO, ONE_ZERO_CHAR, CharOperation.NO_CHAR, new char[][]{superinterface}, CharOperation.NO_CHAR_CHAR, true);
                        }
                    } else {
                        MethodBinding binding;
                        ReferenceExpression referenceExpression = (ReferenceExpression)expression;
                        if (!referenceExpression.isArrayConstructorReference() && (binding = referenceExpression.getMethodBinding()) != null && binding.isValidBinding()) {
                            if (referenceExpression.isMethodReference()) {
                                this.addMethodReference(binding.selector, binding.parameters.length);
                            } else {
                                this.addConstructorReference(binding.declaringClass.sourceName(), binding.parameters.length);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                if (!JobManager.VERBOSE) break block9;
                e.printStackTrace();
            }
        }
    }
}

