/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.util;

import org.greenrobot.eclipse.jdt.core.util.ClassFormatException;
import org.greenrobot.eclipse.jdt.core.util.IConstantPool;
import org.greenrobot.eclipse.jdt.core.util.IConstantPoolEntry;
import org.greenrobot.eclipse.jdt.core.util.ILocalVariableTypeTableEntry;
import org.greenrobot.eclipse.jdt.internal.core.util.ClassFileStruct;

public class LocalVariableTypeTableEntry
extends ClassFileStruct
implements ILocalVariableTypeTableEntry {
    private int startPC;
    private int length;
    private int nameIndex;
    private int signatureIndex;
    private char[] name;
    private char[] signature;
    private int index;

    public LocalVariableTypeTableEntry(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        this.startPC = this.u2At(classFileBytes, 0, offset);
        this.length = this.u2At(classFileBytes, 2, offset);
        this.nameIndex = this.u2At(classFileBytes, 4, offset);
        this.signatureIndex = this.u2At(classFileBytes, 6, offset);
        this.index = this.u2At(classFileBytes, 8, offset);
        IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.nameIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.name = constantPoolEntry.getUtf8Value();
        constantPoolEntry = constantPool.decodeEntry(this.signatureIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.signature = constantPoolEntry.getUtf8Value();
    }

    @Override
    public int getStartPC() {
        return this.startPC;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getNameIndex() {
        return this.nameIndex;
    }

    @Override
    public int getSignatureIndex() {
        return this.signatureIndex;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public char[] getName() {
        return this.name;
    }

    @Override
    public char[] getSignature() {
        return this.signature;
    }
}

