/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jface.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.greenrobot.eclipse.core.runtime.Assert;
import org.greenrobot.eclipse.core.runtime.ISafeRunnable;
import org.greenrobot.eclipse.core.runtime.ListenerList;
import org.greenrobot.eclipse.core.runtime.SafeRunner;
import org.greenrobot.eclipse.jface.text.BadLocationException;
import org.greenrobot.eclipse.jface.text.BadPartitioningException;
import org.greenrobot.eclipse.jface.text.BadPositionCategoryException;
import org.greenrobot.eclipse.jface.text.DefaultPositionUpdater;
import org.greenrobot.eclipse.jface.text.DocumentEvent;
import org.greenrobot.eclipse.jface.text.DocumentPartitioningChangedEvent;
import org.greenrobot.eclipse.jface.text.DocumentRewriteSession;
import org.greenrobot.eclipse.jface.text.DocumentRewriteSessionEvent;
import org.greenrobot.eclipse.jface.text.DocumentRewriteSessionType;
import org.greenrobot.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.greenrobot.eclipse.jface.text.IDocument;
import org.greenrobot.eclipse.jface.text.IDocumentExtension;
import org.greenrobot.eclipse.jface.text.IDocumentExtension2;
import org.greenrobot.eclipse.jface.text.IDocumentExtension3;
import org.greenrobot.eclipse.jface.text.IDocumentExtension4;
import org.greenrobot.eclipse.jface.text.IDocumentListener;
import org.greenrobot.eclipse.jface.text.IDocumentPartitioner;
import org.greenrobot.eclipse.jface.text.IDocumentPartitionerExtension;
import org.greenrobot.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.greenrobot.eclipse.jface.text.IDocumentPartitionerExtension3;
import org.greenrobot.eclipse.jface.text.IDocumentPartitioningListener;
import org.greenrobot.eclipse.jface.text.IDocumentPartitioningListenerExtension;
import org.greenrobot.eclipse.jface.text.IDocumentPartitioningListenerExtension2;
import org.greenrobot.eclipse.jface.text.IDocumentRewriteSessionListener;
import org.greenrobot.eclipse.jface.text.ILineTracker;
import org.greenrobot.eclipse.jface.text.ILineTrackerExtension;
import org.greenrobot.eclipse.jface.text.IPositionUpdater;
import org.greenrobot.eclipse.jface.text.IRegion;
import org.greenrobot.eclipse.jface.text.IRepairableDocument;
import org.greenrobot.eclipse.jface.text.IRepairableDocumentExtension;
import org.greenrobot.eclipse.jface.text.ITextStore;
import org.greenrobot.eclipse.jface.text.ITypedRegion;
import org.greenrobot.eclipse.jface.text.Position;
import org.greenrobot.eclipse.jface.text.TypedRegion;

public abstract class AbstractDocument
implements IDocument,
IDocumentExtension,
IDocumentExtension2,
IDocumentExtension3,
IDocumentExtension4,
IRepairableDocument,
IRepairableDocumentExtension {
    private static final boolean DEBUG = false;
    private ITextStore fStore;
    private ILineTracker fTracker;
    private ListenerList<IDocumentListener> fDocumentListeners;
    private ListenerList<IDocumentListener> fPrenotifiedDocumentListeners;
    private ListenerList<IDocumentPartitioningListener> fDocumentPartitioningListeners;
    private Map<String, List<Position>> fPositions;
    private Map<String, List<Position>> fEndPositions;
    private List<IPositionUpdater> fPositionUpdaters;
    private List<RegisteredReplace> fPostNotificationChanges;
    private int fReentranceCount = 0;
    private int fStoppedCount = 0;
    private boolean fAcceptPostNotificationReplaces = true;
    private int fStoppedListenerNotification = 0;
    private DocumentEvent fDeferredDocumentEvent;
    private Map<String, IDocumentPartitioner> fDocumentPartitioners;
    private DocumentPartitioningChangedEvent fDocumentPartitioningChangedEvent;
    private FindReplaceDocumentAdapter fFindReplaceDocumentAdapter;
    private DocumentRewriteSession fDocumentRewriteSession;
    private List<IDocumentRewriteSessionListener> fDocumentRewriteSessionListeners;
    private long fModificationStamp = this.getNextModificationStamp();
    private long fNextModificationStamp = -1L;
    private String fInitialLineDelimiter;

    protected AbstractDocument() {
    }

    protected ITextStore getStore() {
        Assert.isNotNull(this.fStore);
        return this.fStore;
    }

    protected ILineTracker getTracker() {
        Assert.isNotNull(this.fTracker);
        return this.fTracker;
    }

    private static <T> List<T> asList(ListenerList<T> listenerList) {
        List<Object> list;
        List<Object> castList = list = Arrays.asList(listenerList.getListeners());
        return castList;
    }

    protected List<IDocumentListener> getDocumentListeners() {
        return AbstractDocument.asList(this.fDocumentListeners);
    }

    protected List<IDocumentPartitioningListener> getDocumentPartitioningListeners() {
        return AbstractDocument.asList(this.fDocumentPartitioningListeners);
    }

    protected Map<String, List<Position>> getDocumentManagedPositions() {
        return this.fPositions;
    }

    @Override
    public IDocumentPartitioner getDocumentPartitioner() {
        return this.getDocumentPartitioner("__dftl_partitioning");
    }

    protected void setTextStore(ITextStore store) {
        this.fStore = store;
    }

    protected void setLineTracker(ILineTracker tracker) {
        this.fTracker = tracker;
    }

    @Override
    public void setDocumentPartitioner(IDocumentPartitioner partitioner) {
        this.setDocumentPartitioner("__dftl_partitioning", partitioner);
    }

    protected void completeInitialization() {
        this.fPositions = new HashMap<String, List<Position>>();
        this.fEndPositions = new HashMap<String, List<Position>>();
        this.fPositionUpdaters = new ArrayList<IPositionUpdater>();
        this.fDocumentListeners = new ListenerList(1);
        this.fPrenotifiedDocumentListeners = new ListenerList(1);
        this.fDocumentPartitioningListeners = new ListenerList(1);
        this.fDocumentRewriteSessionListeners = new ArrayList<IDocumentRewriteSessionListener>();
        this.addPositionCategory("__dflt_position_category");
        this.addPositionUpdater(new DefaultPositionUpdater("__dflt_position_category"));
    }

    @Override
    public void addDocumentListener(IDocumentListener listener) {
        Assert.isNotNull(listener);
        this.fDocumentListeners.add(listener);
    }

    @Override
    public void removeDocumentListener(IDocumentListener listener) {
        Assert.isNotNull(listener);
        this.fDocumentListeners.remove(listener);
    }

    @Override
    public void addPrenotifiedDocumentListener(IDocumentListener listener) {
        Assert.isNotNull(listener);
        this.fPrenotifiedDocumentListeners.add(listener);
    }

    @Override
    public void removePrenotifiedDocumentListener(IDocumentListener listener) {
        Assert.isNotNull(listener);
        this.fPrenotifiedDocumentListeners.remove(listener);
    }

    @Override
    public void addDocumentPartitioningListener(IDocumentPartitioningListener listener) {
        Assert.isNotNull(listener);
        this.fDocumentPartitioningListeners.add(listener);
    }

    @Override
    public void removeDocumentPartitioningListener(IDocumentPartitioningListener listener) {
        Assert.isNotNull(listener);
        this.fDocumentPartitioningListeners.remove(listener);
    }

    @Override
    public void addPosition(String category, Position position) throws BadLocationException, BadPositionCategoryException {
        if (position.offset < 0 || position.length < 0 || position.offset + position.length > this.getLength()) {
            throw new BadLocationException();
        }
        if (category == null) {
            throw new BadPositionCategoryException();
        }
        List<Position> list = this.fPositions.get(category);
        if (list == null) {
            throw new BadPositionCategoryException();
        }
        list.add(this.computeIndexInPositionList(list, position.offset), position);
        List<Position> endPositions = this.fEndPositions.get(category);
        if (endPositions == null) {
            throw new BadPositionCategoryException();
        }
        endPositions.add(this.computeIndexInPositionList(endPositions, position.offset + position.length - 1, false), position);
    }

    @Override
    public void addPosition(Position position) throws BadLocationException {
        try {
            this.addPosition("__dflt_position_category", position);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    @Override
    public void addPositionCategory(String category) {
        if (category == null) {
            return;
        }
        if (!this.containsPositionCategory(category)) {
            this.fPositions.put(category, new ArrayList());
            this.fEndPositions.put(category, new ArrayList());
        }
    }

    @Override
    public void addPositionUpdater(IPositionUpdater updater) {
        this.insertPositionUpdater(updater, this.fPositionUpdaters.size());
    }

    @Override
    public boolean containsPosition(String category, int offset, int length) {
        if (category == null) {
            return false;
        }
        List<Position> list = this.fPositions.get(category);
        if (list == null) {
            return false;
        }
        int size = list.size();
        if (size == 0) {
            return false;
        }
        int index = this.computeIndexInPositionList(list, offset);
        if (index < size) {
            Position p = list.get(index);
            while (p != null && p.offset == offset) {
                if (p.length == length) {
                    return true;
                }
                Position position = p = ++index < size ? list.get(index) : null;
            }
        }
        return false;
    }

    @Override
    public boolean containsPositionCategory(String category) {
        if (category != null) {
            return this.fPositions.containsKey(category);
        }
        return false;
    }

    @Deprecated
    protected int computeIndexInPositionList(List<? extends Position> positions, int offset) {
        return this.computeIndexInPositionList(positions, offset, true);
    }

    protected int computeIndexInPositionList(List<? extends Position> positions, int offset, boolean orderedByOffset) {
        if (positions.size() == 0) {
            return 0;
        }
        int left = 0;
        int right = positions.size() - 1;
        int mid = 0;
        Position p = null;
        while (left < right) {
            mid = (left + right) / 2;
            p = positions.get(mid);
            int pOffset = this.getOffset(orderedByOffset, p);
            if (offset < pOffset) {
                if (left == mid) {
                    right = left;
                    continue;
                }
                right = mid - 1;
                continue;
            }
            if (offset > pOffset) {
                if (right == mid) {
                    left = right;
                    continue;
                }
                left = mid + 1;
                continue;
            }
            if (offset != pOffset) continue;
            left = right = mid;
        }
        int pos = left;
        p = positions.get(pos);
        int pPosition = this.getOffset(orderedByOffset, p);
        if (offset > pPosition) {
            ++pos;
        } else {
            while (--pos >= 0 && offset == (pPosition = this.getOffset(orderedByOffset, p = positions.get(pos)))) {
            }
            ++pos;
        }
        Assert.isTrue(pos >= 0 && pos <= positions.size());
        return pos;
    }

    private int getOffset(boolean orderedByOffset, Position position) {
        if (orderedByOffset || position.getLength() == 0) {
            return position.getOffset();
        }
        return position.getOffset() + position.getLength() - 1;
    }

    @Override
    public int computeIndexInCategory(String category, int offset) throws BadLocationException, BadPositionCategoryException {
        if (offset < 0 || offset > this.getLength()) {
            throw new BadLocationException();
        }
        List<Position> c = this.fPositions.get(category);
        if (c == null) {
            throw new BadPositionCategoryException();
        }
        return this.computeIndexInPositionList(c, offset);
    }

    @Deprecated
    protected void fireDocumentPartitioningChanged() {
        if (this.fDocumentPartitioningListeners == null) {
            return;
        }
        for (IDocumentPartitioningListener listener : this.fDocumentPartitioningListeners) {
            listener.documentPartitioningChanged(this);
        }
    }

    @Deprecated
    protected void fireDocumentPartitioningChanged(IRegion region) {
        if (this.fDocumentPartitioningListeners == null) {
            return;
        }
        for (IDocumentPartitioningListener l : this.fDocumentPartitioningListeners) {
            try {
                if (l instanceof IDocumentPartitioningListenerExtension) {
                    ((IDocumentPartitioningListenerExtension)((Object)l)).documentPartitioningChanged(this, region);
                    continue;
                }
                l.documentPartitioningChanged(this);
            }
            catch (Exception ex) {
                AbstractDocument.log(ex);
            }
        }
    }

    protected void fireDocumentPartitioningChanged(DocumentPartitioningChangedEvent event) {
        if (this.fDocumentPartitioningListeners == null) {
            return;
        }
        for (IDocumentPartitioningListener l : this.fDocumentPartitioningListeners) {
            try {
                if (l instanceof IDocumentPartitioningListenerExtension2) {
                    IDocumentPartitioningListenerExtension2 extension2 = (IDocumentPartitioningListenerExtension2)((Object)l);
                    extension2.documentPartitioningChanged(event);
                    continue;
                }
                if (l instanceof IDocumentPartitioningListenerExtension) {
                    IDocumentPartitioningListenerExtension extension = (IDocumentPartitioningListenerExtension)((Object)l);
                    extension.documentPartitioningChanged(this, event.getCoverage());
                    continue;
                }
                l.documentPartitioningChanged(this);
            }
            catch (Exception ex) {
                AbstractDocument.log(ex);
            }
        }
    }

    protected void fireDocumentAboutToBeChanged(DocumentEvent event) {
        if (this.fReentranceCount == 0) {
            this.flushPostNotificationChanges();
        }
        if (this.fDocumentPartitioners != null) {
            for (IDocumentPartitioner p : this.fDocumentPartitioners.values()) {
                IDocumentPartitionerExtension3 extension;
                if (p instanceof IDocumentPartitionerExtension3 && (extension = (IDocumentPartitionerExtension3)((Object)p)).getActiveRewriteSession() != null) continue;
                try {
                    p.documentAboutToBeChanged(event);
                }
                catch (Exception ex) {
                    AbstractDocument.log(ex);
                }
            }
        }
        for (IDocumentListener listener : this.fPrenotifiedDocumentListeners) {
            try {
                listener.documentAboutToBeChanged(event);
            }
            catch (Exception ex) {
                AbstractDocument.log(ex);
            }
        }
        for (IDocumentListener listener : this.fDocumentListeners) {
            try {
                listener.documentAboutToBeChanged(event);
            }
            catch (Exception ex) {
                AbstractDocument.log(ex);
            }
        }
    }

    protected void updateDocumentStructures(DocumentEvent event) {
        if (this.fDocumentPartitioners != null) {
            this.fDocumentPartitioningChangedEvent = new DocumentPartitioningChangedEvent(this);
            for (String partitioning : this.fDocumentPartitioners.keySet()) {
                Object extension;
                IDocumentPartitioner partitioner = this.fDocumentPartitioners.get(partitioning);
                if (partitioner instanceof IDocumentPartitionerExtension3 && (extension = (IDocumentPartitionerExtension3)((Object)partitioner)).getActiveRewriteSession() != null) continue;
                if (partitioner instanceof IDocumentPartitionerExtension) {
                    extension = (IDocumentPartitionerExtension)((Object)partitioner);
                    IRegion r = extension.documentChanged2(event);
                    if (r == null) continue;
                    this.fDocumentPartitioningChangedEvent.setPartitionChange(partitioning, r.getOffset(), r.getLength());
                    continue;
                }
                if (!partitioner.documentChanged(event)) continue;
                this.fDocumentPartitioningChangedEvent.setPartitionChange(partitioning, 0, event.getDocument().getLength());
            }
        }
        if (this.fPositions.size() > 0) {
            this.updatePositions(event);
        }
    }

    protected void doFireDocumentChanged(DocumentEvent event) {
        boolean changed = this.fDocumentPartitioningChangedEvent != null && !this.fDocumentPartitioningChangedEvent.isEmpty();
        IRegion change = changed ? this.fDocumentPartitioningChangedEvent.getCoverage() : null;
        this.doFireDocumentChanged(event, changed, change);
    }

    @Deprecated
    protected void doFireDocumentChanged(DocumentEvent event, boolean firePartitionChange, IRegion partitionChange) {
        this.doFireDocumentChanged2(event);
    }

    protected void doFireDocumentChanged2(DocumentEvent event) {
        DocumentPartitioningChangedEvent p = this.fDocumentPartitioningChangedEvent;
        this.fDocumentPartitioningChangedEvent = null;
        if (p != null && !p.isEmpty()) {
            this.fireDocumentPartitioningChanged(p);
        }
        for (IDocumentListener listener : this.fPrenotifiedDocumentListeners) {
            try {
                listener.documentChanged(event);
            }
            catch (Exception ex) {
                AbstractDocument.log(ex);
            }
        }
        for (IDocumentListener listener : this.fDocumentListeners) {
            try {
                listener.documentChanged(event);
            }
            catch (Exception ex) {
                AbstractDocument.log(ex);
            }
        }
        ++this.fReentranceCount;
        try {
            if (this.fReentranceCount == 1) {
                this.executePostNotificationChanges();
            }
        }
        finally {
            --this.fReentranceCount;
        }
    }

    protected void fireDocumentChanged(DocumentEvent event) {
        this.updateDocumentStructures(event);
        if (this.fStoppedListenerNotification == 0) {
            this.doFireDocumentChanged(event);
        } else {
            this.fDeferredDocumentEvent = event;
        }
    }

    @Override
    public char getChar(int pos) throws BadLocationException {
        if (pos < 0 || pos >= this.getLength()) {
            throw new BadLocationException();
        }
        return this.getStore().get(pos);
    }

    @Override
    public String getContentType(int offset) throws BadLocationException {
        String contentType = null;
        try {
            contentType = this.getContentType("__dftl_partitioning", offset, false);
            Assert.isNotNull(contentType);
        }
        catch (BadPartitioningException badPartitioningException) {
            Assert.isTrue(false);
        }
        return contentType;
    }

    @Override
    public String[] getLegalContentTypes() {
        String[] contentTypes = null;
        try {
            contentTypes = this.getLegalContentTypes("__dftl_partitioning");
            Assert.isNotNull(contentTypes);
        }
        catch (BadPartitioningException badPartitioningException) {
            Assert.isTrue(false);
        }
        return contentTypes;
    }

    @Override
    public int getLength() {
        return this.getStore().getLength();
    }

    @Override
    public String getLineDelimiter(int line) throws BadLocationException {
        return this.getTracker().getLineDelimiter(line);
    }

    @Override
    public String[] getLegalLineDelimiters() {
        return this.getTracker().getLegalLineDelimiters();
    }

    @Override
    public String getDefaultLineDelimiter() {
        String lineDelimiter = null;
        try {
            lineDelimiter = this.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        if (lineDelimiter != null) {
            return lineDelimiter;
        }
        if (this.fInitialLineDelimiter != null) {
            return this.fInitialLineDelimiter;
        }
        String sysLineDelimiter = System.getProperty("line.separator");
        String[] delimiters = this.getLegalLineDelimiters();
        Assert.isTrue(delimiters.length > 0);
        int i = 0;
        while (i < delimiters.length) {
            if (delimiters[i].equals(sysLineDelimiter)) {
                lineDelimiter = sysLineDelimiter;
                break;
            }
            ++i;
        }
        if (lineDelimiter == null) {
            lineDelimiter = delimiters[0];
        }
        return lineDelimiter;
    }

    @Override
    public void setInitialLineDelimiter(String lineDelimiter) {
        Assert.isNotNull(lineDelimiter);
        this.fInitialLineDelimiter = lineDelimiter;
    }

    @Override
    public int getLineLength(int line) throws BadLocationException {
        return this.getTracker().getLineLength(line);
    }

    @Override
    public int getLineOfOffset(int pos) throws BadLocationException {
        return this.getTracker().getLineNumberOfOffset(pos);
    }

    @Override
    public int getLineOffset(int line) throws BadLocationException {
        return this.getTracker().getLineOffset(line);
    }

    @Override
    public IRegion getLineInformation(int line) throws BadLocationException {
        return this.getTracker().getLineInformation(line);
    }

    @Override
    public IRegion getLineInformationOfOffset(int offset) throws BadLocationException {
        return this.getTracker().getLineInformationOfOffset(offset);
    }

    @Override
    public int getNumberOfLines() {
        return this.getTracker().getNumberOfLines();
    }

    @Override
    public int getNumberOfLines(int offset, int length) throws BadLocationException {
        return this.getTracker().getNumberOfLines(offset, length);
    }

    @Override
    public int computeNumberOfLines(String text) {
        return this.getTracker().computeNumberOfLines(text);
    }

    @Override
    public ITypedRegion getPartition(int offset) throws BadLocationException {
        ITypedRegion partition = null;
        try {
            partition = this.getPartition("__dftl_partitioning", offset, false);
            Assert.isNotNull(partition);
        }
        catch (BadPartitioningException badPartitioningException) {
            Assert.isTrue(false);
        }
        return partition;
    }

    @Override
    public ITypedRegion[] computePartitioning(int offset, int length) throws BadLocationException {
        ITypedRegion[] partitioning = null;
        try {
            partitioning = this.computePartitioning("__dftl_partitioning", offset, length, false);
            Assert.isNotNull(partitioning);
        }
        catch (BadPartitioningException badPartitioningException) {
            Assert.isTrue(false);
        }
        return partitioning;
    }

    @Override
    public Position[] getPositions(String category) throws BadPositionCategoryException {
        if (category == null) {
            throw new BadPositionCategoryException();
        }
        List<Position> c = this.fPositions.get(category);
        if (c == null) {
            throw new BadPositionCategoryException();
        }
        Position[] positions = new Position[c.size()];
        c.toArray(positions);
        return positions;
    }

    @Override
    public String[] getPositionCategories() {
        String[] categories = new String[this.fPositions.size()];
        Iterator<String> keys = this.fPositions.keySet().iterator();
        int i = 0;
        while (i < categories.length) {
            categories[i] = keys.next();
            ++i;
        }
        return categories;
    }

    @Override
    public IPositionUpdater[] getPositionUpdaters() {
        IPositionUpdater[] updaters = new IPositionUpdater[this.fPositionUpdaters.size()];
        this.fPositionUpdaters.toArray(updaters);
        return updaters;
    }

    @Override
    public String get() {
        return this.getStore().get(0, this.getLength());
    }

    @Override
    public String get(int pos, int length) throws BadLocationException {
        int myLength = this.getLength();
        if (pos < 0 || length < 0 || pos + length > myLength) {
            throw new BadLocationException();
        }
        return this.getStore().get(pos, length);
    }

    @Override
    public void insertPositionUpdater(IPositionUpdater updater, int index) {
        int i = this.fPositionUpdaters.size() - 1;
        while (i >= 0) {
            if (this.fPositionUpdaters.get(i) == updater) {
                return;
            }
            --i;
        }
        if (index == this.fPositionUpdaters.size()) {
            this.fPositionUpdaters.add(updater);
        } else {
            this.fPositionUpdaters.add(index, updater);
        }
    }

    @Override
    public void removePosition(String category, Position position) throws BadPositionCategoryException {
        if (position == null) {
            return;
        }
        if (category == null) {
            throw new BadPositionCategoryException();
        }
        List<Position> c = this.fPositions.get(category);
        if (c == null) {
            throw new BadPositionCategoryException();
        }
        this.removeFromPositionsList(c, position, true);
        List<Position> endPositions = this.fEndPositions.get(category);
        if (endPositions == null) {
            throw new BadPositionCategoryException();
        }
        this.removeFromPositionsList(endPositions, position, false);
    }

    private void removeFromPositionsList(List<Position> positions, Position position, boolean orderedByOffset) {
        int size = positions.size();
        int index = this.computeIndexInPositionList(positions, orderedByOffset ? position.offset : position.offset + position.length - 1, orderedByOffset);
        if (index < size && positions.get(index) == position) {
            positions.remove(index);
            return;
        }
        int back = index - 1;
        int forth = index + 1;
        while (back >= 0 || forth < size) {
            if (back >= 0) {
                if (position == positions.get(back)) {
                    positions.remove(back);
                    return;
                }
                --back;
            }
            if (forth >= size) continue;
            if (position == positions.get(forth)) {
                positions.remove(forth);
                return;
            }
            ++forth;
        }
    }

    @Override
    public void removePosition(Position position) {
        try {
            this.removePosition("__dflt_position_category", position);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    @Override
    public void removePositionCategory(String category) throws BadPositionCategoryException {
        if (category == null) {
            return;
        }
        if (!this.containsPositionCategory(category)) {
            throw new BadPositionCategoryException();
        }
        this.fPositions.remove(category);
        this.fEndPositions.remove(category);
    }

    @Override
    public void removePositionUpdater(IPositionUpdater updater) {
        int i = this.fPositionUpdaters.size() - 1;
        while (i >= 0) {
            if (this.fPositionUpdaters.get(i) == updater) {
                this.fPositionUpdaters.remove(i);
                return;
            }
            --i;
        }
    }

    private long getNextModificationStamp() {
        this.fNextModificationStamp = this.fNextModificationStamp == Long.MAX_VALUE || this.fNextModificationStamp == -1L ? 0L : ++this.fNextModificationStamp;
        return this.fNextModificationStamp;
    }

    @Override
    public long getModificationStamp() {
        return this.fModificationStamp;
    }

    @Override
    public void replace(int pos, int length, String text, long modificationStamp) throws BadLocationException {
        if (pos < 0 || length < 0 || pos + length > this.getLength()) {
            throw new BadLocationException();
        }
        DocumentEvent e = new DocumentEvent(this, pos, length, text);
        this.fireDocumentAboutToBeChanged(e);
        this.getStore().replace(pos, length, text);
        this.getTracker().replace(pos, length, text);
        this.fModificationStamp = modificationStamp;
        this.fNextModificationStamp = Math.max(this.fModificationStamp, this.fNextModificationStamp);
        e.fModificationStamp = this.fModificationStamp;
        this.fireDocumentChanged(e);
    }

    @Override
    public boolean isLineInformationRepairNeeded(int offset, int length, String text) throws BadLocationException {
        return false;
    }

    @Override
    public void replace(int pos, int length, String text) throws BadLocationException {
        if (length == 0 && (text == null || text.length() == 0)) {
            this.replace(pos, length, text, this.getModificationStamp());
        } else {
            this.replace(pos, length, text, this.getNextModificationStamp());
        }
    }

    @Override
    public void set(String text) {
        this.set(text, this.getNextModificationStamp());
    }

    @Override
    public void set(String text, long modificationStamp) {
        int length = this.getStore().getLength();
        DocumentEvent e = new DocumentEvent(this, 0, length, text);
        this.fireDocumentAboutToBeChanged(e);
        this.getStore().set(text);
        this.getTracker().set(text);
        this.fModificationStamp = modificationStamp;
        this.fNextModificationStamp = Math.max(this.fModificationStamp, this.fNextModificationStamp);
        e.fModificationStamp = this.fModificationStamp;
        this.fireDocumentChanged(e);
    }

    protected void updatePositions(DocumentEvent event) {
        ArrayList<IPositionUpdater> list = new ArrayList<IPositionUpdater>(this.fPositionUpdaters);
        for (IPositionUpdater u : list) {
            u.update(event);
        }
    }

    @Override
    @Deprecated
    public int search(int startPosition, String findString, boolean forwardSearch, boolean caseSensitive, boolean wholeWord) throws BadLocationException {
        try {
            IRegion region = this.getFindReplaceDocumentAdapter().find(startPosition, findString, forwardSearch, caseSensitive, wholeWord, false);
            return region == null ? -1 : region.getOffset();
        }
        catch (IllegalStateException illegalStateException) {
            return -1;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return -1;
        }
    }

    private FindReplaceDocumentAdapter getFindReplaceDocumentAdapter() {
        if (this.fFindReplaceDocumentAdapter == null) {
            this.fFindReplaceDocumentAdapter = new FindReplaceDocumentAdapter(this);
        }
        return this.fFindReplaceDocumentAdapter;
    }

    private void flushPostNotificationChanges() {
        if (this.fPostNotificationChanges != null) {
            this.fPostNotificationChanges.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void executePostNotificationChanges() {
        if (this.fStoppedCount <= 0) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            changes = this.fPostNotificationChanges;
            this.fPostNotificationChanges = null;
            for (RegisteredReplace replace : changes) {
                replace.fReplace.perform(this, replace.fOwner);
            }
lbl8:
            // 2 sources

            ** while (this.fPostNotificationChanges != null)
        }
lbl9:
        // 1 sources

    }

    @Override
    public void acceptPostNotificationReplaces() {
        this.fAcceptPostNotificationReplaces = true;
    }

    @Override
    public void ignorePostNotificationReplaces() {
        this.fAcceptPostNotificationReplaces = false;
    }

    @Override
    public void registerPostNotificationReplace(IDocumentListener owner, IDocumentExtension.IReplace replace) {
        if (this.fAcceptPostNotificationReplaces) {
            if (this.fPostNotificationChanges == null) {
                this.fPostNotificationChanges = new ArrayList<RegisteredReplace>(1);
            }
            this.fPostNotificationChanges.add(new RegisteredReplace(owner, replace));
        }
    }

    @Override
    public void stopPostNotificationProcessing() {
        ++this.fStoppedCount;
    }

    @Override
    public void resumePostNotificationProcessing() {
        --this.fStoppedCount;
        if (this.fStoppedCount == 0 && this.fReentranceCount == 0) {
            this.executePostNotificationChanges();
        }
    }

    @Override
    @Deprecated
    public void startSequentialRewrite(boolean normalized) {
    }

    @Override
    @Deprecated
    public void stopSequentialRewrite() {
    }

    @Override
    public void resumeListenerNotification() {
        --this.fStoppedListenerNotification;
        if (this.fStoppedListenerNotification == 0) {
            this.resumeDocumentListenerNotification();
        }
    }

    @Override
    public void stopListenerNotification() {
        ++this.fStoppedListenerNotification;
    }

    private void resumeDocumentListenerNotification() {
        if (this.fDeferredDocumentEvent != null) {
            DocumentEvent event = this.fDeferredDocumentEvent;
            this.fDeferredDocumentEvent = null;
            this.doFireDocumentChanged(event);
        }
    }

    @Override
    public ITypedRegion[] computePartitioning(String partitioning, int offset, int length, boolean includeZeroLengthPartitions) throws BadLocationException, BadPartitioningException {
        if (offset < 0 || length < 0 || offset + length > this.getLength()) {
            throw new BadLocationException();
        }
        IDocumentPartitioner partitioner = this.getDocumentPartitioner(partitioning);
        if (partitioner instanceof IDocumentPartitionerExtension2) {
            this.checkStateOfPartitioner(partitioner, partitioning);
            return ((IDocumentPartitionerExtension2)((Object)partitioner)).computePartitioning(offset, length, includeZeroLengthPartitions);
        }
        if (partitioner != null) {
            this.checkStateOfPartitioner(partitioner, partitioning);
            return partitioner.computePartitioning(offset, length);
        }
        if ("__dftl_partitioning".equals(partitioning)) {
            return new TypedRegion[]{new TypedRegion(offset, length, "__dftl_partition_content_type")};
        }
        throw new BadPartitioningException();
    }

    @Override
    public String getContentType(String partitioning, int offset, boolean preferOpenPartitions) throws BadLocationException, BadPartitioningException {
        if (offset < 0 || offset > this.getLength()) {
            throw new BadLocationException();
        }
        IDocumentPartitioner partitioner = this.getDocumentPartitioner(partitioning);
        if (partitioner instanceof IDocumentPartitionerExtension2) {
            this.checkStateOfPartitioner(partitioner, partitioning);
            return ((IDocumentPartitionerExtension2)((Object)partitioner)).getContentType(offset, preferOpenPartitions);
        }
        if (partitioner != null) {
            this.checkStateOfPartitioner(partitioner, partitioning);
            return partitioner.getContentType(offset);
        }
        if ("__dftl_partitioning".equals(partitioning)) {
            return "__dftl_partition_content_type";
        }
        throw new BadPartitioningException();
    }

    @Override
    public IDocumentPartitioner getDocumentPartitioner(String partitioning) {
        return this.fDocumentPartitioners != null ? this.fDocumentPartitioners.get(partitioning) : null;
    }

    @Override
    public String[] getLegalContentTypes(String partitioning) throws BadPartitioningException {
        IDocumentPartitioner partitioner = this.getDocumentPartitioner(partitioning);
        if (partitioner != null) {
            return partitioner.getLegalContentTypes();
        }
        if ("__dftl_partitioning".equals(partitioning)) {
            return new String[]{"__dftl_partition_content_type"};
        }
        throw new BadPartitioningException();
    }

    @Override
    public ITypedRegion getPartition(String partitioning, int offset, boolean preferOpenPartitions) throws BadLocationException, BadPartitioningException {
        if (offset < 0 || offset > this.getLength()) {
            throw new BadLocationException();
        }
        IDocumentPartitioner partitioner = this.getDocumentPartitioner(partitioning);
        if (partitioner instanceof IDocumentPartitionerExtension2) {
            this.checkStateOfPartitioner(partitioner, partitioning);
            return ((IDocumentPartitionerExtension2)((Object)partitioner)).getPartition(offset, preferOpenPartitions);
        }
        if (partitioner != null) {
            this.checkStateOfPartitioner(partitioner, partitioning);
            return partitioner.getPartition(offset);
        }
        if ("__dftl_partitioning".equals(partitioning)) {
            return new TypedRegion(0, this.getLength(), "__dftl_partition_content_type");
        }
        throw new BadPartitioningException();
    }

    @Override
    public String[] getPartitionings() {
        if (this.fDocumentPartitioners == null) {
            return new String[0];
        }
        String[] partitionings = new String[this.fDocumentPartitioners.size()];
        this.fDocumentPartitioners.keySet().toArray(partitionings);
        return partitionings;
    }

    @Override
    public void setDocumentPartitioner(String partitioning, IDocumentPartitioner partitioner) {
        if (partitioner == null) {
            if (this.fDocumentPartitioners != null) {
                this.fDocumentPartitioners.remove(partitioning);
                if (this.fDocumentPartitioners.size() == 0) {
                    this.fDocumentPartitioners = null;
                }
            }
        } else {
            if (this.fDocumentPartitioners == null) {
                this.fDocumentPartitioners = new HashMap<String, IDocumentPartitioner>();
            }
            this.fDocumentPartitioners.put(partitioning, partitioner);
        }
        DocumentPartitioningChangedEvent event = new DocumentPartitioningChangedEvent(this);
        event.setPartitionChange(partitioning, 0, this.getLength());
        this.fireDocumentPartitioningChanged(event);
    }

    @Override
    public void repairLineInformation() {
        this.getTracker().set(this.get());
    }

    protected void fireRewriteSessionChanged(DocumentRewriteSessionEvent event) {
        if (this.fDocumentRewriteSessionListeners.size() > 0) {
            ArrayList<IDocumentRewriteSessionListener> list = new ArrayList<IDocumentRewriteSessionListener>(this.fDocumentRewriteSessionListeners);
            Iterator e = list.iterator();
            while (e.hasNext()) {
                try {
                    IDocumentRewriteSessionListener l = (IDocumentRewriteSessionListener)e.next();
                    l.documentRewriteSessionChanged(event);
                }
                catch (Exception ex) {
                    AbstractDocument.log(ex);
                }
            }
        }
    }

    @Override
    public final DocumentRewriteSession getActiveRewriteSession() {
        return this.fDocumentRewriteSession;
    }

    @Override
    public DocumentRewriteSession startRewriteSession(DocumentRewriteSessionType sessionType) {
        if (this.getActiveRewriteSession() != null) {
            throw new IllegalStateException();
        }
        this.fDocumentRewriteSession = new DocumentRewriteSession(sessionType);
        this.fireRewriteSessionChanged(new DocumentRewriteSessionEvent(this, this.fDocumentRewriteSession, DocumentRewriteSessionEvent.SESSION_START));
        this.startRewriteSessionOnPartitioners(this.fDocumentRewriteSession);
        ILineTracker tracker = this.getTracker();
        if (tracker instanceof ILineTrackerExtension) {
            ILineTrackerExtension extension = (ILineTrackerExtension)((Object)tracker);
            extension.startRewriteSession(this.fDocumentRewriteSession);
        }
        if (DocumentRewriteSessionType.SEQUENTIAL == sessionType) {
            this.startSequentialRewrite(false);
        } else if (DocumentRewriteSessionType.STRICTLY_SEQUENTIAL == sessionType) {
            this.startSequentialRewrite(true);
        }
        return this.fDocumentRewriteSession;
    }

    protected final void startRewriteSessionOnPartitioners(DocumentRewriteSession session) {
        if (this.fDocumentPartitioners != null) {
            for (IDocumentPartitioner partitioner : this.fDocumentPartitioners.values()) {
                if (!(partitioner instanceof IDocumentPartitionerExtension3)) continue;
                IDocumentPartitionerExtension3 extension = (IDocumentPartitionerExtension3)((Object)partitioner);
                extension.startRewriteSession(session);
            }
        }
    }

    @Override
    public void stopRewriteSession(DocumentRewriteSession session) {
        if (this.fDocumentRewriteSession == session) {
            ILineTracker tracker;
            DocumentRewriteSessionType sessionType = session.getSessionType();
            if (DocumentRewriteSessionType.SEQUENTIAL == sessionType || DocumentRewriteSessionType.STRICTLY_SEQUENTIAL == sessionType) {
                this.stopSequentialRewrite();
            }
            if ((tracker = this.getTracker()) instanceof ILineTrackerExtension) {
                ILineTrackerExtension extension = (ILineTrackerExtension)((Object)tracker);
                extension.stopRewriteSession(session, this.get());
            }
            this.stopRewriteSessionOnPartitioners(this.fDocumentRewriteSession);
            this.fDocumentRewriteSession = null;
            this.fireRewriteSessionChanged(new DocumentRewriteSessionEvent(this, session, DocumentRewriteSessionEvent.SESSION_STOP));
        }
    }

    protected final void stopRewriteSessionOnPartitioners(DocumentRewriteSession session) {
        if (this.fDocumentPartitioners != null) {
            DocumentPartitioningChangedEvent event = new DocumentPartitioningChangedEvent(this);
            for (String partitioning : this.fDocumentPartitioners.keySet()) {
                IDocumentPartitioner partitioner = this.fDocumentPartitioners.get(partitioning);
                if (!(partitioner instanceof IDocumentPartitionerExtension3)) continue;
                IDocumentPartitionerExtension3 extension = (IDocumentPartitionerExtension3)((Object)partitioner);
                extension.stopRewriteSession(session);
                event.setPartitionChange(partitioning, 0, this.getLength());
            }
            if (!event.isEmpty()) {
                this.fireDocumentPartitioningChanged(event);
            }
        }
    }

    @Override
    public void addDocumentRewriteSessionListener(IDocumentRewriteSessionListener listener) {
        Assert.isNotNull(listener);
        if (!this.fDocumentRewriteSessionListeners.contains(listener)) {
            this.fDocumentRewriteSessionListeners.add(listener);
        }
    }

    @Override
    public void removeDocumentRewriteSessionListener(IDocumentRewriteSessionListener listener) {
        Assert.isNotNull(listener);
        this.fDocumentRewriteSessionListeners.remove(listener);
    }

    protected final void checkStateOfPartitioner(IDocumentPartitioner partitioner, String partitioning) {
        if (!(partitioner instanceof IDocumentPartitionerExtension3)) {
            return;
        }
        IDocumentPartitionerExtension3 extension = (IDocumentPartitionerExtension3)((Object)partitioner);
        DocumentRewriteSession session = extension.getActiveRewriteSession();
        if (session != null) {
            extension.stopRewriteSession(session);
            DocumentPartitioningChangedEvent event = new DocumentPartitioningChangedEvent(this);
            event.setPartitionChange(partitioning, 0, this.getLength());
            this.fireDocumentPartitioningChanged(event);
        }
    }

    public Position[] getPositions(String category, int offset, int length, boolean canStartBefore, boolean canEndAfter) throws BadPositionCategoryException {
        if (canStartBefore && canEndAfter || !canStartBefore && !canEndAfter) {
            List<Position> documentPositions = canStartBefore && canEndAfter ? (offset < this.getLength() / 2 ? this.getStartingPositions(category, 0, offset + length) : this.getEndingPositions(category, offset, this.getLength() - offset + 1)) : this.getStartingPositions(category, offset, length);
            ArrayList<Position> list = new ArrayList<Position>(documentPositions.size());
            Position region = new Position(offset, length);
            for (Position position : documentPositions) {
                if (!this.isWithinRegion(region, position, canStartBefore, canEndAfter)) continue;
                list.add(position);
            }
            Position[] positions = new Position[list.size()];
            list.toArray(positions);
            return positions;
        }
        if (canStartBefore) {
            List<Position> list = this.getEndingPositions(category, offset, length);
            Position[] positions = new Position[list.size()];
            list.toArray(positions);
            return positions;
        }
        Assert.isLegal(canEndAfter && !canStartBefore);
        List<Position> list = this.getStartingPositions(category, offset, length);
        Position[] positions = new Position[list.size()];
        list.toArray(positions);
        return positions;
    }

    private boolean isWithinRegion(Position region, Position position, boolean canStartBefore, boolean canEndAfter) {
        if (canStartBefore && canEndAfter) {
            return region.overlapsWith(position.getOffset(), position.getLength());
        }
        if (canStartBefore) {
            return region.includes(position.getOffset() + position.getLength() - 1);
        }
        if (canEndAfter) {
            return region.includes(position.getOffset());
        }
        int start = position.getOffset();
        return region.includes(start) && region.includes(start + position.getLength() - 1);
    }

    private List<Position> getStartingPositions(String category, int offset, int length) throws BadPositionCategoryException {
        List<Position> positions = this.fPositions.get(category);
        if (positions == null) {
            throw new BadPositionCategoryException();
        }
        int indexStart = this.computeIndexInPositionList(positions, offset, true);
        int indexEnd = this.computeIndexInPositionList(positions, offset + length, true);
        return positions.subList(indexStart, indexEnd);
    }

    private List<Position> getEndingPositions(String category, int offset, int length) throws BadPositionCategoryException {
        List<Position> positions = this.fEndPositions.get(category);
        if (positions == null) {
            throw new BadPositionCategoryException();
        }
        int indexStart = this.computeIndexInPositionList(positions, offset, false);
        int indexEnd = this.computeIndexInPositionList(positions, offset + length, false);
        return positions.subList(indexStart, indexEnd);
    }

    private static void log(final Exception ex) {
        SafeRunner.run(new ISafeRunnable(){

            @Override
            public void run() throws Exception {
                throw ex;
            }

            @Override
            public void handleException(Throwable exception) {
            }
        });
    }

    private static class RegisteredReplace {
        IDocumentListener fOwner;
        IDocumentExtension.IReplace fReplace;

        RegisteredReplace(IDocumentListener owner, IDocumentExtension.IReplace replace) {
            this.fOwner = owner;
            this.fReplace = replace;
        }
    }
}

