/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jface.text.link;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.greenrobot.eclipse.core.runtime.Assert;
import org.greenrobot.eclipse.jface.text.IDocument;
import org.greenrobot.eclipse.jface.text.link.ILinkedModeListener;
import org.greenrobot.eclipse.jface.text.link.LinkedModeModel;

class LinkedModeManager {
    private static Map<IDocument, LinkedModeManager> fgManagers = new HashMap<IDocument, LinkedModeManager>();
    private Stack<LinkedModeModel> fEnvironments = new Stack();
    private Listener fListener = new Listener();

    LinkedModeManager() {
    }

    public static boolean hasManager(IDocument document) {
        return fgManagers.get(document) != null;
    }

    public static boolean hasManager(IDocument[] documents) {
        int i = 0;
        while (i < documents.length) {
            if (LinkedModeManager.hasManager(documents[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static LinkedModeManager getLinkedManager(IDocument[] documents, boolean force) {
        if (documents == null || documents.length == 0) {
            return null;
        }
        HashSet<LinkedModeManager> mgrs = new HashSet<LinkedModeManager>();
        LinkedModeManager mgr = null;
        int i = 0;
        while (i < documents.length) {
            mgr = fgManagers.get(documents[i]);
            if (mgr != null) {
                mgrs.add(mgr);
            }
            ++i;
        }
        if (mgrs.size() > 1) {
            if (force) {
                for (LinkedModeManager m : mgrs) {
                    m.closeAllEnvironments();
                }
            } else {
                return null;
            }
        }
        if (mgrs.size() == 0) {
            mgr = new LinkedModeManager();
        }
        i = 0;
        while (i < documents.length) {
            fgManagers.put(documents[i], mgr);
            ++i;
        }
        return mgr;
    }

    public static void cancelManager(IDocument document) {
        LinkedModeManager mgr = fgManagers.get(document);
        if (mgr != null) {
            mgr.closeAllEnvironments();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void left(LinkedModeModel model, int flags) {
        if (this.fEnvironments.contains(model)) ** GOTO lbl5
        return;
        while ((env = this.fEnvironments.pop()) != model) {
            env.exit(0);
lbl5:
            // 2 sources

            if (!this.fEnvironments.isEmpty()) continue;
        }
        if (this.fEnvironments.isEmpty()) {
            this.removeManager();
        }
    }

    private void closeAllEnvironments() {
        while (!this.fEnvironments.isEmpty()) {
            LinkedModeModel env = this.fEnvironments.pop();
            env.exit(0);
        }
        this.removeManager();
    }

    private void removeManager() {
        Iterator<IDocument> it = fgManagers.keySet().iterator();
        while (it.hasNext()) {
            IDocument doc = it.next();
            if (fgManagers.get(doc) != this) continue;
            it.remove();
        }
    }

    /*
     * Loose catch block
     */
    public boolean nestEnvironment(LinkedModeModel model, boolean force) {
        Assert.isNotNull(model);
        while (true) {
            if (!this.fEnvironments.isEmpty()) break block6;
            model.addLinkingListener(this.fListener);
            this.fEnvironments.push(model);
            break;
        }
        catch (Throwable throwable) {
            Assert.isTrue(this.fEnvironments.size() > 0);
            throw throwable;
        }
        {
            LinkedModeModel top;
            block8: {
                block7: {
                    block6: {
                        Assert.isTrue(this.fEnvironments.size() > 0);
                        return true;
                    }
                    top = this.fEnvironments.peek();
                    if (!model.canNestInto(top)) break block7;
                    model.addLinkingListener(this.fListener);
                    this.fEnvironments.push(model);
                    Assert.isTrue(this.fEnvironments.size() > 0);
                    return true;
                }
                if (force) break block8;
                Assert.isTrue(this.fEnvironments.size() > 0);
                return false;
            }
            this.fEnvironments.pop();
            top.exit(0);
            continue;
        }
    }

    public LinkedModeModel getTopEnvironment() {
        if (this.fEnvironments.isEmpty()) {
            return null;
        }
        return this.fEnvironments.peek();
    }

    private class Listener
    implements ILinkedModeListener {
        private Listener() {
        }

        @Override
        public void left(LinkedModeModel model, int flags) {
            LinkedModeManager.this.left(model, flags);
        }

        @Override
        public void suspend(LinkedModeModel model) {
        }

        @Override
        public void resume(LinkedModeModel model, int flags) {
        }
    }
}

