/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.greenrobot.eclipse.osgi.container.ModuleCapability;
import org.greenrobot.eclipse.osgi.container.ModuleRequirement;
import org.greenrobot.eclipse.osgi.container.ModuleRevisionBuilder;
import org.greenrobot.eclipse.osgi.container.ModuleRevisions;
import org.greenrobot.eclipse.osgi.container.ModuleWiring;
import org.greenrobot.eclipse.osgi.internal.container.InternalUtils;
import org.greenrobot.osgi.framework.Bundle;
import org.greenrobot.osgi.framework.Version;
import org.greenrobot.osgi.framework.wiring.BundleCapability;
import org.greenrobot.osgi.framework.wiring.BundleRequirement;
import org.greenrobot.osgi.framework.wiring.BundleRevision;
import org.greenrobot.osgi.resource.Capability;
import org.greenrobot.osgi.resource.Requirement;

public final class ModuleRevision
implements BundleRevision {
    private final String symbolicName;
    private final Version version;
    private final int types;
    private final List<ModuleCapability> capabilities;
    private final List<ModuleRequirement> requirements;
    private final ModuleRevisions revisions;
    private final Object revisionInfo;
    private volatile Boolean lazyActivationPolicy = null;

    ModuleRevision(String symbolicName, Version version, int types, List<ModuleRevisionBuilder.GenericInfo> capabilityInfos, List<ModuleRevisionBuilder.GenericInfo> requirementInfos, ModuleRevisions revisions, Object revisionInfo) {
        this.symbolicName = symbolicName;
        this.version = version;
        this.types = types;
        this.capabilities = this.createCapabilities(capabilityInfos);
        this.requirements = this.createRequirements(requirementInfos);
        this.revisions = revisions;
        this.revisionInfo = revisionInfo;
    }

    private List<ModuleCapability> createCapabilities(List<ModuleRevisionBuilder.GenericInfo> capabilityInfos) {
        if (capabilityInfos == null || capabilityInfos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModuleCapability> result = new ArrayList<ModuleCapability>(capabilityInfos.size());
        for (ModuleRevisionBuilder.GenericInfo info : capabilityInfos) {
            result.add(new ModuleCapability(info.namespace, info.directives, info.attributes, this));
        }
        return result;
    }

    private List<ModuleRequirement> createRequirements(List<ModuleRevisionBuilder.GenericInfo> requirementInfos) {
        if (requirementInfos == null || requirementInfos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModuleRequirement> result = new ArrayList<ModuleRequirement>(requirementInfos.size());
        for (ModuleRevisionBuilder.GenericInfo info : requirementInfos) {
            result.add(new ModuleRequirement(info.namespace, info.directives, info.attributes, this));
        }
        return result;
    }

    @Override
    public Bundle getBundle() {
        return this.revisions.getBundle();
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public List<BundleCapability> getDeclaredCapabilities(String namespace) {
        return InternalUtils.asListBundleCapability(this.getModuleCapabilities(namespace));
    }

    @Override
    public List<BundleRequirement> getDeclaredRequirements(String namespace) {
        return InternalUtils.asListBundleRequirement(this.getModuleRequirements(namespace));
    }

    public List<ModuleCapability> getModuleCapabilities(String namespace) {
        if (namespace == null) {
            return Collections.unmodifiableList(this.capabilities);
        }
        ArrayList<ModuleCapability> result = new ArrayList<ModuleCapability>();
        for (ModuleCapability capability : this.capabilities) {
            if (!namespace.equals(capability.getNamespace())) continue;
            result.add(capability);
        }
        return Collections.unmodifiableList(result);
    }

    public List<ModuleRequirement> getModuleRequirements(String namespace) {
        if (namespace == null) {
            return Collections.unmodifiableList(this.requirements);
        }
        ArrayList<ModuleRequirement> result = new ArrayList<ModuleRequirement>();
        for (ModuleRequirement requirement : this.requirements) {
            if (!namespace.equals(requirement.getNamespace())) continue;
            result.add(requirement);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public int getTypes() {
        return this.types;
    }

    @Override
    public ModuleWiring getWiring() {
        return this.revisions.getContainer().getWiring(this);
    }

    @Override
    public List<Capability> getCapabilities(String namespace) {
        return InternalUtils.asListCapability(this.getDeclaredCapabilities(namespace));
    }

    @Override
    public List<Requirement> getRequirements(String namespace) {
        return InternalUtils.asListRequirement(this.getDeclaredRequirements(namespace));
    }

    public ModuleRevisions getRevisions() {
        return this.revisions;
    }

    public Object getRevisionInfo() {
        return this.revisionInfo;
    }

    public boolean hasLazyActivatePolicy() {
        Boolean currentPolicy = this.lazyActivationPolicy;
        if (currentPolicy != null) {
            return currentPolicy;
        }
        boolean lazyPolicy = false;
        List<Capability> data = this.getCapabilities("equinox.module.data");
        if (!data.isEmpty()) {
            Capability moduleData = data.get(0);
            lazyPolicy = "lazy".equals(moduleData.getAttributes().get("activation.policy"));
        }
        this.lazyActivationPolicy = lazyPolicy;
        return lazyPolicy;
    }

    boolean isCurrent() {
        return !this.revisions.isUninstalled() && this.equals(this.revisions.getCurrentRevision());
    }

    public String toString() {
        List<ModuleCapability> identities = this.getModuleCapabilities("osgi.identity");
        if (identities.isEmpty()) {
            return super.toString();
        }
        return identities.get(0).toString();
    }

    static <V> String toString(Map<String, V> map, boolean directives) {
        return ModuleRevision.toString(map, directives, false);
    }

    static <V> String toString(Map<String, V> map, boolean directives, boolean stringsOnly) {
        if (map.size() == 0) {
            return "";
        }
        String assignment = directives ? ":=" : "=";
        Set<Map.Entry<String, V>> set = map.entrySet();
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, V> entry : set) {
            sb.append("; ");
            String key = entry.getKey();
            V value = entry.getValue();
            if (value instanceof List) {
                List list = (List)value;
                if (list.size() == 0) continue;
                Object component = list.get(0);
                String className = component.getClass().getName();
                String type = className.substring(className.lastIndexOf(46) + 1);
                sb.append(key).append(':').append("List<").append(type).append(">").append(assignment).append('\"');
                for (Object object : list) {
                    sb.append(object).append(',');
                }
                sb.setLength(sb.length() - 1);
                sb.append('\"');
                continue;
            }
            String type = "";
            if (!(value instanceof String) && !stringsOnly) {
                String className = value.getClass().getName();
                type = ":" + className.substring(className.lastIndexOf(46) + 1);
            }
            sb.append(key).append(type).append(assignment).append('\"').append(value).append('\"');
        }
        return sb.toString();
    }
}

