/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.loader;

import java.security.AccessController;
import java.util.Map;
import org.greenrobot.eclipse.osgi.container.ModuleCapability;
import org.greenrobot.eclipse.osgi.framework.util.KeyedHashSet;
import org.greenrobot.eclipse.osgi.framework.util.SecureAction;
import org.greenrobot.eclipse.osgi.internal.loader.BundleLoader;
import org.greenrobot.eclipse.osgi.internal.loader.sources.FilteredSourcePackage;
import org.greenrobot.eclipse.osgi.internal.loader.sources.PackageSource;
import org.greenrobot.eclipse.osgi.internal.loader.sources.SingleSourcePackage;

public class BundleLoaderSources {
    static SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private final KeyedHashSet pkgSources = new KeyedHashSet(false);
    private final BundleLoader loader;

    public BundleLoaderSources(BundleLoader loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageSource getPackageSource(String pkgName) {
        KeyedHashSet keyedHashSet = this.pkgSources;
        synchronized (keyedHashSet) {
            PackageSource pkgSource = (PackageSource)this.pkgSources.getByKey(pkgName);
            if (pkgSource == null) {
                pkgSource = new SingleSourcePackage(pkgName, this.loader);
                this.pkgSources.add(pkgSource);
            }
            return pkgSource;
        }
    }

    boolean forceSourceCreation(ModuleCapability packageCapability) {
        Map<String, String> directives = packageCapability.getDirectives();
        return directives.get("exclude") != null || directives.get("exclude") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageSource createPackageSource(ModuleCapability packageCapability, boolean storeSource) {
        PackageSource pkgSource = null;
        String name = (String)packageCapability.getAttributes().get("osgi.wiring.package");
        String includes = packageCapability.getDirectives().get("include");
        String excludes = packageCapability.getDirectives().get("exclude");
        if (includes != null || excludes != null) {
            pkgSource = new FilteredSourcePackage(name, this.loader, includes, excludes);
        }
        if (storeSource) {
            if (pkgSource != null) {
                KeyedHashSet keyedHashSet = this.pkgSources;
                synchronized (keyedHashSet) {
                    if (this.pkgSources.getByKey(name) == null) {
                        this.pkgSources.add(pkgSource);
                    }
                }
            }
        } else if (pkgSource == null && (pkgSource = this.getPackageSource(name)).getClass() != SingleSourcePackage.class) {
            return new SingleSourcePackage(name, this.loader);
        }
        return pkgSource;
    }
}

