/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.loader;

import java.lang.reflect.Method;
import org.greenrobot.eclipse.osgi.internal.debug.Debug;
import org.greenrobot.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.greenrobot.eclipse.osgi.internal.loader.BundleLoader;
import org.greenrobot.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.greenrobot.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.greenrobot.eclipse.osgi.storage.BundleInfo;

public class EquinoxClassLoader
extends ModuleClassLoader {
    private static final boolean EQUINOX_REGISTERED_AS_PARALLEL;
    private final EquinoxConfiguration configuration;
    private final Debug debug;
    private final BundleLoader delegate;
    private final BundleInfo.Generation generation;
    private final ClasspathManager manager;
    private final boolean isRegisteredAsParallel;

    static {
        boolean registeredAsParallel;
        try {
            Method parallelCapableMetod = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", null);
            parallelCapableMetod.setAccessible(true);
            registeredAsParallel = (Boolean)parallelCapableMetod.invoke(null, null);
        }
        catch (Throwable throwable) {
            registeredAsParallel = false;
        }
        EQUINOX_REGISTERED_AS_PARALLEL = registeredAsParallel;
    }

    public EquinoxClassLoader(ClassLoader parent, EquinoxConfiguration configuration, BundleLoader delegate, BundleInfo.Generation generation) {
        super(parent);
        this.configuration = configuration;
        this.debug = configuration.getDebug();
        this.delegate = delegate;
        this.generation = generation;
        this.manager = new ClasspathManager(generation, this);
        this.isRegisteredAsParallel = ModuleClassLoader.REGISTERED_AS_PARALLEL && EQUINOX_REGISTERED_AS_PARALLEL || this.configuration.PARALLEL_CAPABLE;
    }

    @Override
    protected final BundleInfo.Generation getGeneration() {
        return this.generation;
    }

    @Override
    public final ClasspathManager getClasspathManager() {
        return this.manager;
    }

    @Override
    public final boolean isRegisteredAsParallel() {
        return this.isRegisteredAsParallel;
    }

    @Override
    public final BundleLoader getBundleLoader() {
        return this.delegate;
    }

    @Override
    protected final Debug getDebug() {
        return this.debug;
    }

    @Override
    protected final EquinoxConfiguration getConfiguration() {
        return this.configuration;
    }
}

