/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.log;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.greenrobot.eclipse.equinox.log.ExtendedLogReaderService;
import org.greenrobot.eclipse.equinox.log.ExtendedLogService;
import org.greenrobot.eclipse.equinox.log.LogFilter;
import org.greenrobot.eclipse.osgi.internal.log.EventAdminAdapter;
import org.greenrobot.eclipse.osgi.internal.log.ExtendedLogReaderServiceFactory;
import org.greenrobot.eclipse.osgi.internal.log.ExtendedLogServiceFactory;
import org.greenrobot.eclipse.osgi.internal.log.ExtendedLogServiceImpl;
import org.greenrobot.osgi.framework.Bundle;
import org.greenrobot.osgi.framework.BundleContext;
import org.greenrobot.osgi.framework.BundleEvent;
import org.greenrobot.osgi.framework.BundleListener;
import org.greenrobot.osgi.framework.FrameworkEvent;
import org.greenrobot.osgi.framework.FrameworkListener;
import org.greenrobot.osgi.framework.ServiceEvent;
import org.greenrobot.osgi.framework.ServiceListener;
import org.greenrobot.osgi.framework.ServiceReference;
import org.greenrobot.osgi.framework.ServiceRegistration;
import org.greenrobot.osgi.framework.Version;
import org.greenrobot.osgi.service.log.LogListener;
import org.greenrobot.osgi.service.log.LogReaderService;
import org.greenrobot.osgi.service.log.LogService;

public class LogServiceManager
implements BundleListener,
FrameworkListener,
ServiceListener {
    private static final String[] LOGSERVICE_CLASSES = new String[]{LogService.class.getName(), ExtendedLogService.class.getName()};
    private static final String[] LOGREADERSERVICE_CLASSES = new String[]{LogReaderService.class.getName(), ExtendedLogReaderService.class.getName()};
    private ServiceRegistration<?> logReaderServiceRegistration;
    private ServiceRegistration<?> logServiceRegistration;
    private final ExtendedLogReaderServiceFactory logReaderServiceFactory;
    private final ExtendedLogServiceFactory logServiceFactory;
    private final ExtendedLogServiceImpl systemBundleLog;
    private EventAdminAdapter eventAdminAdapter;

    public LogServiceManager(int maxHistory, LogListener ... systemListeners) {
        this.logReaderServiceFactory = new ExtendedLogReaderServiceFactory(maxHistory);
        this.logServiceFactory = new ExtendedLogServiceFactory(this.logReaderServiceFactory);
        this.systemBundleLog = this.logServiceFactory.getLogService(new MockSystemBundle());
        LogListener[] logListenerArray = systemListeners;
        int n = systemListeners.length;
        int n2 = 0;
        while (n2 < n) {
            LogListener logListener = logListenerArray[n2];
            if (logListener instanceof LogFilter) {
                this.logReaderServiceFactory.addLogListener(logListener, (LogFilter)((Object)logListener));
            } else {
                this.logReaderServiceFactory.addLogListener(logListener, ExtendedLogReaderServiceFactory.NULL_LOGGER_FILTER);
            }
            ++n2;
        }
    }

    public void start(BundleContext context) {
        this.systemBundleLog.setBundle(context.getBundle());
        context.addBundleListener(this);
        context.addServiceListener(this);
        context.addFrameworkListener(this);
        context.addBundleListener(this.logServiceFactory);
        this.logReaderServiceRegistration = context.registerService(LOGREADERSERVICE_CLASSES, (Object)this.logReaderServiceFactory, null);
        this.logServiceRegistration = context.registerService(LOGSERVICE_CLASSES, (Object)this.logServiceFactory, null);
        this.eventAdminAdapter = new EventAdminAdapter(context, this.logReaderServiceFactory);
        this.eventAdminAdapter.start();
    }

    public void stop(BundleContext context) {
        this.eventAdminAdapter.stop();
        this.eventAdminAdapter = null;
        this.logServiceRegistration.unregister();
        this.logServiceRegistration = null;
        this.logReaderServiceRegistration.unregister();
        this.logReaderServiceRegistration = null;
        this.logServiceFactory.shutdown();
        context.removeFrameworkListener(this);
        context.removeServiceListener(this);
        context.removeBundleListener(this);
    }

    public ExtendedLogService getSystemBundleLog() {
        return this.systemBundleLog;
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (this.logReaderServiceFactory.isLoggable(bundle, null, 3)) {
            this.logReaderServiceFactory.log(bundle, null, null, 3, LogServiceManager.getBundleEventTypeName(event.getType()), null);
        }
    }

    @Override
    public void serviceChanged(ServiceEvent event) {
        int logType;
        ServiceReference<?> reference = event.getServiceReference();
        Bundle bundle = reference.getBundle();
        int eventType = event.getType();
        int n = logType = eventType == 2 ? 4 : 3;
        if (this.logReaderServiceFactory.isLoggable(bundle, null, logType)) {
            this.logReaderServiceFactory.log(bundle, null, reference, logType, LogServiceManager.getServiceEventTypeName(eventType), null);
        }
    }

    @Override
    public void frameworkEvent(FrameworkEvent event) {
        Throwable throwable;
        Bundle bundle = event.getBundle();
        int eventType = event.getType();
        int logType = eventType == 2 ? 1 : 3;
        Throwable throwable2 = throwable = eventType == 2 ? event.getThrowable() : null;
        if (this.logReaderServiceFactory.isLoggable(bundle, null, logType)) {
            this.logReaderServiceFactory.log(bundle, null, null, logType, LogServiceManager.getFrameworkEventTypeName(eventType), throwable);
        }
    }

    private static String getBundleEventTypeName(int type) {
        switch (type) {
            case 1: {
                return "BundleEvent INSTALLED";
            }
            case 32: {
                return "BundleEvent RESOLVED";
            }
            case 2: {
                return "BundleEvent STARTED";
            }
            case 128: {
                return "BundleEvent STARTING";
            }
            case 4: {
                return "BundleEvent STOPPED";
            }
            case 256: {
                return "BundleEvent STOPPING";
            }
            case 16: {
                return "BundleEvent UNINSTALLED";
            }
            case 64: {
                return "BundleEvent UNRESOLVED";
            }
            case 8: {
                return "BundleEvent UPDATED";
            }
        }
        return "BundleEvent " + Integer.toHexString(type);
    }

    private static String getServiceEventTypeName(int type) {
        switch (type) {
            case 1: {
                return "ServiceEvent REGISTERED";
            }
            case 2: {
                return "ServiceEvent MODIFIED";
            }
            case 4: {
                return "ServiceEvent UNREGISTERING";
            }
        }
        return "ServiceEvent " + Integer.toHexString(type);
    }

    private static String getFrameworkEventTypeName(int type) {
        switch (type) {
            case 2: {
                return "FrameworkEvent ERROR";
            }
            case 32: {
                return "FrameworkEvent INFO";
            }
            case 4: {
                return "FrameworkEvent PACKAGES REFRESHED";
            }
            case 1: {
                return "FrameworkEvent STARTED";
            }
            case 8: {
                return "FrameworkEvent STARTLEVEL CHANGED";
            }
            case 16: {
                return "FrameworkEvent WARNING";
            }
        }
        return "FrameworkEvent " + Integer.toHexString(type);
    }

    static class MockSystemBundle
    implements Bundle {
        MockSystemBundle() {
        }

        @Override
        public int compareTo(Bundle o) {
            long idcomp = this.getBundleId() - o.getBundleId();
            return idcomp < 0L ? -1 : (idcomp > 0L ? 1 : 0);
        }

        @Override
        public int getState() {
            return 4;
        }

        @Override
        public void start(int options) {
        }

        @Override
        public void start() {
        }

        @Override
        public void stop(int options) {
        }

        @Override
        public void stop() {
        }

        @Override
        public void update(InputStream input) {
        }

        @Override
        public void update() {
        }

        @Override
        public void uninstall() {
        }

        @Override
        public Dictionary<String, String> getHeaders() {
            return new Hashtable<String, String>();
        }

        @Override
        public long getBundleId() {
            return 0L;
        }

        @Override
        public String getLocation() {
            return "System Bundle";
        }

        @Override
        public ServiceReference<?>[] getRegisteredServices() {
            return null;
        }

        @Override
        public ServiceReference<?>[] getServicesInUse() {
            return null;
        }

        @Override
        public boolean hasPermission(Object permission) {
            return true;
        }

        @Override
        public URL getResource(String name) {
            return null;
        }

        @Override
        public Dictionary<String, String> getHeaders(String locale) {
            return null;
        }

        @Override
        public String getSymbolicName() {
            return "org.greenrobot.eclipse.osgi";
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException();
        }

        @Override
        public Enumeration<URL> getResources(String name) {
            return null;
        }

        @Override
        public Enumeration<String> getEntryPaths(String path) {
            return null;
        }

        @Override
        public URL getEntry(String path) {
            return null;
        }

        @Override
        public long getLastModified() {
            return System.currentTimeMillis();
        }

        @Override
        public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            return null;
        }

        @Override
        public BundleContext getBundleContext() {
            return null;
        }

        @Override
        public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
            return new HashMap<X509Certificate, List<X509Certificate>>();
        }

        @Override
        public Version getVersion() {
            return new Version(0, 0, 0);
        }

        @Override
        public <A> A adapt(Class<A> type) {
            return null;
        }

        @Override
        public File getDataFile(String filename) {
            return null;
        }
    }
}

