/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.url;

import java.lang.reflect.Method;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.greenrobot.eclipse.osgi.internal.framework.EquinoxContainer;
import org.greenrobot.eclipse.osgi.internal.messages.Msg;
import org.greenrobot.eclipse.osgi.internal.url.ContentHandlerProxy;
import org.greenrobot.eclipse.osgi.internal.url.MultiplexingContentHandler;
import org.greenrobot.eclipse.osgi.internal.url.MultiplexingFactory;
import org.greenrobot.eclipse.osgi.internal.url.URLStreamHandlerFactoryImpl;
import org.greenrobot.eclipse.osgi.util.NLS;
import org.greenrobot.osgi.framework.BundleContext;
import org.greenrobot.osgi.framework.ServiceReference;
import org.greenrobot.osgi.util.tracker.ServiceTracker;

public class ContentHandlerFactoryImpl
extends MultiplexingFactory
implements ContentHandlerFactory {
    private ServiceTracker<ContentHandler, ContentHandler> contentHandlerTracker;
    private static final String contentHandlerClazz = "java.net.ContentHandler";
    private static final String CONTENT_HANDLER_PKGS = "java.content.handler.pkgs";
    private static final String DEFAULT_VM_CONTENT_HANDLERS = "sun.net.www.content";
    private static final List<Class<?>> ignoredClasses = Arrays.asList(MultiplexingContentHandler.class, ContentHandlerFactoryImpl.class, URLConnection.class);
    private Map<String, ContentHandlerProxy> proxies = new Hashtable<String, ContentHandlerProxy>(5);
    private ContentHandlerFactory parentFactory;

    public ContentHandlerFactoryImpl(BundleContext context, EquinoxContainer container) {
        super(context, container);
        this.contentHandlerTracker = new ServiceTracker(context, contentHandlerClazz, null);
        this.contentHandlerTracker.open();
    }

    @Override
    public ContentHandler createContentHandler(String contentType) {
        String builtInHandlers = URLStreamHandlerFactoryImpl.secureAction.getProperty(CONTENT_HANDLER_PKGS);
        builtInHandlers = builtInHandlers == null ? DEFAULT_VM_CONTENT_HANDLERS : "sun.net.www.content|" + builtInHandlers;
        Class<?> clazz = null;
        if (builtInHandlers != null) {
            String convertedContentType = contentType.replace('.', '_');
            convertedContentType = convertedContentType.replace('/', '.');
            convertedContentType = convertedContentType.replace('-', '_');
            StringTokenizer tok = new StringTokenizer(builtInHandlers, "|");
            while (tok.hasMoreElements()) {
                StringBuffer name = new StringBuffer();
                name.append(tok.nextToken());
                name.append(".");
                name.append(convertedContentType);
                try {
                    clazz = URLStreamHandlerFactoryImpl.secureAction.loadSystemClass(name.toString());
                    if (clazz == null) continue;
                    return null;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        if (this.isMultiplexing()) {
            return new MultiplexingContentHandler(contentType, this);
        }
        return this.createInternalContentHandler(contentType);
    }

    public ContentHandler createInternalContentHandler(String contentType) {
        ContentHandler parentHandler;
        ContentHandlerProxy proxy = this.proxies.get(contentType);
        if (proxy != null) {
            return proxy;
        }
        ServiceReference<ContentHandler>[] serviceReferences = this.contentHandlerTracker.getServiceReferences();
        if (serviceReferences != null) {
            int i = 0;
            while (i < serviceReferences.length) {
                String[] prop = serviceReferences[i].getProperty("url.content.mimetype");
                if (prop instanceof String) {
                    prop = new String[]{(String)prop};
                }
                if (!(prop instanceof String[])) {
                    String message = NLS.bind(Msg.URL_HANDLER_INCORRECT_TYPE, new Object[]{"url.content.mimetype", contentHandlerClazz, serviceReferences[i].getBundle()});
                    this.container.getLogServices().log("org.greenrobot.eclipse.osgi", 2, message, null);
                } else {
                    String[] contentHandler = prop;
                    int j = 0;
                    while (j < contentHandler.length) {
                        if (contentHandler[j].equals(contentType)) {
                            proxy = new ContentHandlerProxy(contentType, serviceReferences[i], this.context);
                            this.proxies.put(contentType, proxy);
                            return proxy;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (this.parentFactory != null && (parentHandler = this.parentFactory.createContentHandler(contentType)) != null) {
            return parentHandler;
        }
        proxy = new ContentHandlerProxy(contentType, null, this.context);
        this.proxies.put(contentType, proxy);
        return proxy;
    }

    public synchronized ContentHandler findAuthorizedContentHandler(String contentType) {
        Object factory = this.findAuthorizedFactory(ignoredClasses);
        if (factory == null) {
            return null;
        }
        if (factory == this) {
            return this.createInternalContentHandler(contentType);
        }
        try {
            Method createInternalContentHandlerMethod = factory.getClass().getMethod("createInternalContentHandler", String.class);
            return (ContentHandler)createInternalContentHandlerMethod.invoke(factory, contentType);
        }
        catch (Exception e) {
            this.container.getLogServices().log(ContentHandlerFactoryImpl.class.getName(), 4, "findAuthorizedContentHandler-loop", e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Object getParentFactory() {
        return this.parentFactory;
    }

    @Override
    public void setParentFactory(Object parentFactory) {
        if (this.parentFactory == null) {
            this.parentFactory = (ContentHandlerFactory)parentFactory;
        }
    }
}

