/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.url;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ContentHandlerFactory;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.util.Hashtable;
import org.greenrobot.eclipse.osgi.internal.framework.EquinoxContainer;
import org.greenrobot.eclipse.osgi.internal.url.ContentHandlerFactoryImpl;
import org.greenrobot.eclipse.osgi.internal.url.MultiplexingFactory;
import org.greenrobot.eclipse.osgi.internal.url.URLStreamHandlerFactoryImpl;
import org.greenrobot.osgi.framework.BundleContext;

public class EquinoxFactoryManager {
    private final EquinoxContainer container;
    private volatile URLStreamHandlerFactoryImpl urlStreamHandlerFactory;
    private volatile ContentHandlerFactoryImpl contentHandlerFactory;

    public EquinoxFactoryManager(EquinoxContainer container) {
        this.container = container;
    }

    public void installHandlerFactories(BundleContext context) {
        this.installURLStreamHandlerFactory(context);
        this.installContentHandlerFactory(context);
    }

    private void installURLStreamHandlerFactory(BundleContext context) {
        URLStreamHandlerFactoryImpl shf = new URLStreamHandlerFactoryImpl(context, this.container);
        try {
            URL.setURLStreamHandlerFactory(shf);
        }
        catch (Error err) {
            try {
                EquinoxFactoryManager.forceURLStreamHandlerFactory(shf);
            }
            catch (Exception ex) {
                this.container.getLogServices().log("org.greenrobot.eclipse.osgi", 4, ex.getMessage(), ex);
                throw err;
            }
        }
        this.urlStreamHandlerFactory = shf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceURLStreamHandlerFactory(URLStreamHandlerFactoryImpl shf) throws Exception {
        Object lock;
        Field factoryField = EquinoxFactoryManager.getField(URL.class, URLStreamHandlerFactory.class, false);
        if (factoryField == null) {
            throw new Exception("Could not find URLStreamHandlerFactory field");
        }
        Object object = lock = EquinoxFactoryManager.getURLStreamHandlerFactoryLock();
        synchronized (object) {
            URLStreamHandlerFactory factory = (URLStreamHandlerFactory)factoryField.get(null);
            if (factory != null) {
                try {
                    factory.getClass().getMethod("isMultiplexing", null);
                    Method register = factory.getClass().getMethod("register", Object.class);
                    register.invoke((Object)factory, shf);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    shf.setParentFactory(factory);
                    factory = shf;
                }
            }
            factoryField.set(null, null);
            EquinoxFactoryManager.resetURLStreamHandlers();
            URL.setURLStreamHandlerFactory(factory);
        }
    }

    private static void resetURLStreamHandlers() throws IllegalAccessException {
        Hashtable handlers;
        Field handlersField = EquinoxFactoryManager.getField(URL.class, Hashtable.class, false);
        if (handlersField != null && (handlers = (Hashtable)handlersField.get(null)) != null) {
            handlers.clear();
        }
    }

    private static Object getURLStreamHandlerFactoryLock() throws IllegalAccessException {
        Object lock;
        try {
            Field streamHandlerLockField = URL.class.getDeclaredField("streamHandlerLock");
            MultiplexingFactory.setAccessible(streamHandlerLockField);
            lock = streamHandlerLockField.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            lock = URL.class;
        }
        return lock;
    }

    private void installContentHandlerFactory(BundleContext context) {
        ContentHandlerFactoryImpl chf = new ContentHandlerFactoryImpl(context, this.container);
        try {
            URLConnection.setContentHandlerFactory(chf);
        }
        catch (Error err) {
            try {
                EquinoxFactoryManager.forceContentHandlerFactory(chf);
            }
            catch (Exception ex) {
                this.container.getLogServices().log("org.greenrobot.eclipse.osgi", 4, ex.getMessage(), ex);
                throw err;
            }
        }
        this.contentHandlerFactory = chf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceContentHandlerFactory(ContentHandlerFactoryImpl chf) throws Exception {
        Field factoryField = EquinoxFactoryManager.getField(URLConnection.class, ContentHandlerFactory.class, false);
        if (factoryField == null) {
            throw new Exception("Could not find ContentHandlerFactory field");
        }
        Class<URLConnection> clazz = URLConnection.class;
        synchronized (URLConnection.class) {
            ContentHandlerFactory factory = (ContentHandlerFactory)factoryField.get(null);
            if (factory != null) {
                try {
                    factory.getClass().getMethod("isMultiplexing", null);
                    Method register = factory.getClass().getMethod("register", Object.class);
                    register.invoke((Object)factory, chf);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    chf.setParentFactory(factory);
                    factory = chf;
                }
            }
            factoryField.set(null, null);
            EquinoxFactoryManager.resetContentHandlers();
            URLConnection.setContentHandlerFactory(factory);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static void resetContentHandlers() throws IllegalAccessException {
        Hashtable handlers;
        Field handlersField = EquinoxFactoryManager.getField(URLConnection.class, Hashtable.class, false);
        if (handlersField != null && (handlers = (Hashtable)handlersField.get(null)) != null) {
            handlers.clear();
        }
    }

    public void uninstallHandlerFactories() {
        this.uninstallURLStreamHandlerFactory();
        this.uninstallContentHandlerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallURLStreamHandlerFactory() {
        try {
            Object lock;
            Field factoryField = EquinoxFactoryManager.getField(URL.class, URLStreamHandlerFactory.class, false);
            if (factoryField == null) {
                return;
            }
            Object object = lock = EquinoxFactoryManager.getURLStreamHandlerFactoryLock();
            synchronized (object) {
                URLStreamHandlerFactory factory = (URLStreamHandlerFactory)factoryField.get(null);
                if (factory == this.urlStreamHandlerFactory) {
                    factory = (URLStreamHandlerFactory)this.urlStreamHandlerFactory.designateSuccessor();
                } else {
                    Method unregister = factory.getClass().getMethod("unregister", Object.class);
                    unregister.invoke((Object)factory, this.urlStreamHandlerFactory);
                }
                factoryField.set(null, null);
                EquinoxFactoryManager.resetURLStreamHandlers();
                if (factory != null) {
                    URL.setURLStreamHandlerFactory(factory);
                }
            }
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallContentHandlerFactory() {
        try {
            Field factoryField = EquinoxFactoryManager.getField(URLConnection.class, ContentHandlerFactory.class, false);
            if (factoryField == null) {
                return;
            }
            Class<URLConnection> clazz = URLConnection.class;
            synchronized (URLConnection.class) {
                ContentHandlerFactory factory = (ContentHandlerFactory)factoryField.get(null);
                if (factory == this.contentHandlerFactory) {
                    factory = (ContentHandlerFactory)this.contentHandlerFactory.designateSuccessor();
                } else {
                    Method unregister = factory.getClass().getMethod("unregister", Object.class);
                    unregister.invoke((Object)factory, this.contentHandlerFactory);
                }
                factoryField.set(null, null);
                EquinoxFactoryManager.resetContentHandlers();
                if (factory != null) {
                    URLConnection.setContentHandlerFactory(factory);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Exception exception) {}
        {
            return;
        }
    }

    public static Field getField(Class<?> clazz, Class<?> type, boolean instance) {
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            boolean isStatic = Modifier.isStatic(fields[i].getModifiers());
            if (instance != isStatic && fields[i].getType().equals(type)) {
                MultiplexingFactory.setAccessible(fields[i]);
                return fields[i];
            }
            ++i;
        }
        return null;
    }
}

