/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.weaving;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.greenrobot.eclipse.osgi.internal.framework.EquinoxContainer;
import org.greenrobot.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.greenrobot.eclipse.osgi.internal.loader.BundleLoader;
import org.greenrobot.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.greenrobot.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.greenrobot.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.greenrobot.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.greenrobot.eclipse.osgi.internal.weaving.WovenClassImpl;
import org.greenrobot.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.greenrobot.osgi.framework.Bundle;
import org.greenrobot.osgi.framework.ServiceRegistration;

public class WeavingHookConfigurator
extends ClassLoaderHook {
    private final Map<ServiceRegistration<?>, Boolean> blackList = Collections.synchronizedMap(new WeakHashMap());
    private final ThreadLocal<List<WovenClassImpl>> wovenClassStack = new ThreadLocal();
    private final EquinoxContainer container;

    public WeavingHookConfigurator(EquinoxContainer container) {
        this.container = container;
    }

    private ServiceRegistry getRegistry() {
        return this.container.getServiceRegistry();
    }

    @Override
    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        ServiceRegistry registry = this.getRegistry();
        if (registry == null) {
            return null;
        }
        ModuleClassLoader classLoader = manager.getClassLoader();
        BundleLoader loader = classLoader.getBundleLoader();
        WovenClassImpl wovenClass = new WovenClassImpl(name, classbytes, entry, classpathEntry, loader, this.container, this.blackList);
        List<WovenClassImpl> wovenClasses = this.wovenClassStack.get();
        if (wovenClasses == null) {
            wovenClasses = new ArrayList<WovenClassImpl>(6);
            this.wovenClassStack.set(wovenClasses);
        }
        wovenClasses.add(wovenClass);
        try {
            return wovenClass.callHooks();
        }
        catch (Throwable t) {
            ServiceRegistration<?> errorHook = wovenClass.getErrorHook();
            Bundle errorBundle = errorHook != null ? errorHook.getReference().getBundle() : manager.getGeneration().getRevision().getBundle();
            this.container.getEventPublisher().publishFrameworkEvent(2, errorBundle, t);
            ClassFormatError error = new ClassFormatError("Unexpected error from weaving hook.");
            error.initCause(t);
            throw error;
        }
    }

    @Override
    public void recordClassDefine(String name, Class<?> clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        List<WovenClassImpl> wovenClasses = this.wovenClassStack.get();
        if (wovenClasses == null || wovenClasses.size() == 0) {
            return;
        }
        WovenClassImpl wovenClass = wovenClasses.remove(wovenClasses.size() - 1);
        wovenClass.setWeavingCompleted(clazz);
    }
}

