/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.storage.bundlefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.greenrobot.eclipse.osgi.container.ModuleContainerAdaptor;
import org.greenrobot.eclipse.osgi.container.ModuleRevision;
import org.greenrobot.eclipse.osgi.internal.debug.Debug;
import org.greenrobot.eclipse.osgi.internal.messages.Msg;
import org.greenrobot.eclipse.osgi.storage.BundleInfo;
import org.greenrobot.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.greenrobot.eclipse.osgi.storage.bundlefile.BundleFile;
import org.greenrobot.eclipse.osgi.storage.bundlefile.DirZipBundleEntry;
import org.greenrobot.eclipse.osgi.storage.bundlefile.MRUBundleFileList;
import org.greenrobot.eclipse.osgi.storage.bundlefile.ZipBundleEntry;
import org.greenrobot.eclipse.osgi.util.NLS;
import org.greenrobot.osgi.framework.FrameworkListener;

public class ZipBundleFile
extends BundleFile {
    private final MRUBundleFileList mruList;
    private final BundleInfo.Generation generation;
    private final Debug debug;
    protected volatile ZipFile zipFile;
    protected volatile boolean closed = true;
    private int referenceCount = 0;

    public ZipBundleFile(File basefile, BundleInfo.Generation generation, MRUBundleFileList mruList, Debug debug) throws IOException {
        super(basefile);
        if (!BundleFile.secureAction.exists(basefile)) {
            throw new IOException(NLS.bind(Msg.ADAPTER_FILEEXIST_EXCEPTION, basefile));
        }
        this.debug = debug;
        this.generation = generation;
        this.closed = true;
        this.mruList = mruList;
    }

    protected boolean checkedOpen() {
        try {
            return this.getZipFile() != null;
        }
        catch (IOException e) {
            ModuleRevision r;
            if (this.generation != null && (r = this.generation.getRevision()) != null) {
                ModuleContainerAdaptor.ContainerEvent eventType = ModuleContainerAdaptor.ContainerEvent.ERROR;
                if (!r.getRevisions().getModuleRevisions().contains(r)) {
                    eventType = ModuleContainerAdaptor.ContainerEvent.INFO;
                }
                this.generation.getBundleInfo().getStorage().getAdaptor().publishContainerEvent(eventType, r.getRevisions().getModule(), e, new FrameworkListener[0]);
            }
            return false;
        }
    }

    protected ZipFile basicOpen() throws IOException {
        return BundleFile.secureAction.getZipFile(this.basefile);
    }

    protected synchronized ZipFile getZipFile() throws IOException {
        if (this.closed) {
            this.mruListAdd();
            this.zipFile = this.basicOpen();
            this.closed = false;
        } else {
            this.mruListUse();
        }
        return this.zipFile;
    }

    protected ZipEntry getZipEntry(String path) {
        ZipEntry dirEntry;
        ZipEntry entry;
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if ((entry = this.zipFile.getEntry(path)) != null && entry.getSize() == 0L && !entry.isDirectory() && (dirEntry = this.zipFile.getEntry(String.valueOf(path) + '/')) != null) {
            entry = dirEntry;
        }
        return entry;
    }

    protected synchronized File extractDirectory(String dirName) {
        if (!this.checkedOpen()) {
            return null;
        }
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            String entryPath = entries.nextElement().getName();
            if (!entryPath.startsWith(dirName) || entryPath.endsWith("/")) continue;
            this.getFile(entryPath, false);
        }
        return this.getExtractFile(dirName);
    }

    protected File getExtractFile(String entryName) {
        if (this.generation == null) {
            return null;
        }
        String path = ".cp";
        String name = entryName.replace('/', File.separatorChar);
        path = name.length() > 1 && name.charAt(0) == File.separatorChar ? path.concat(name) : String.valueOf(path) + File.separator + name;
        return this.generation.getExtractFile(path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized File getFile(String entry, boolean nativeCode) {
        InputStream in;
        File nested;
        block10: {
            if (!this.checkedOpen()) {
                return null;
            }
            ZipEntry zipEntry = this.getZipEntry(entry);
            if (zipEntry == null) {
                return null;
            }
            nested = this.getExtractFile(zipEntry.getName());
            if (nested == null) return null;
            if (nested.exists()) {
                if (this.debug.DEBUG_GENERAL) {
                    Debug.println("File already present: " + nested.getPath());
                }
                if (!nested.isDirectory()) return nested;
                this.extractDirectory(zipEntry.getName());
                return nested;
            }
            if (zipEntry.getName().endsWith("/")) {
                nested.mkdirs();
                if (!nested.isDirectory()) {
                    if (!this.debug.DEBUG_GENERAL) throw new IOException(NLS.bind(Msg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, nested.getAbsolutePath()));
                    Debug.println("Unable to create directory: " + nested.getPath());
                    throw new IOException(NLS.bind(Msg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, nested.getAbsolutePath()));
                }
                this.extractDirectory(zipEntry.getName());
                return nested;
            }
            in = this.zipFile.getInputStream(zipEntry);
            if (in != null) break block10;
            return null;
        }
        try {
            this.generation.storeContent(nested, in, nativeCode);
            return nested;
        }
        catch (IOException e) {
            if (this.debug.DEBUG_GENERAL) {
                Debug.printStackTrace(e);
            }
            this.generation.getBundleInfo().getStorage().getLogServices().log("org.greenrobot.eclipse.osgi", 4, "Unable to extract content: " + this.generation.getRevision() + ": " + entry, e);
        }
        return null;
    }

    @Override
    public synchronized boolean containsDir(String dir) {
        if (!this.checkedOpen()) {
            return false;
        }
        if (dir == null) {
            return false;
        }
        if (dir.length() == 0) {
            return true;
        }
        if (dir.charAt(0) == '/') {
            if (dir.length() == 1) {
                return true;
            }
            dir = dir.substring(1);
        }
        if (dir.length() > 0 && dir.charAt(dir.length() - 1) != '/') {
            dir = String.valueOf(dir) + '/';
        }
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String entryPath = zipEntry.getName();
            if (!entryPath.startsWith(dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized BundleEntry getEntry(String path) {
        if (!this.checkedOpen()) {
            return null;
        }
        ZipEntry zipEntry = this.getZipEntry(path);
        if (zipEntry == null) {
            if ((path.length() == 0 || path.charAt(path.length() - 1) == '/') && this.containsDir(path)) {
                return new DirZipBundleEntry(this, path);
            }
            return null;
        }
        return new ZipBundleEntry(zipEntry, this);
    }

    @Override
    public synchronized Enumeration<String> getEntryPaths(String path, boolean recurse) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!this.checkedOpen()) {
            return null;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String entryPath = zipEntry.getName();
            if (!entryPath.startsWith(path) || path.length() >= entryPath.length()) continue;
            this.getEntryPaths(path, entryPath.substring(path.length()), recurse, result);
        }
        return result.size() == 0 ? null : Collections.enumeration(result);
    }

    private void getEntryPaths(String path, String entry, boolean recurse, LinkedHashSet<String> entries) {
        if (entry.length() == 0) {
            return;
        }
        int slash = entry.indexOf(47);
        if (slash == -1) {
            entries.add(String.valueOf(path) + entry);
        } else {
            path = String.valueOf(path) + entry.substring(0, slash + 1);
            entries.add(path);
            if (recurse) {
                this.getEntryPaths(path, entry.substring(slash + 1), true, entries);
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            if (this.referenceCount > 0 && this.isMruListClosing()) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
                if (this.referenceCount != 0 || this.closed) {
                    return;
                }
            }
            this.closed = true;
            this.zipFile.close();
            this.mruListRemove();
        }
    }

    private boolean isMruListClosing() {
        return this.mruList != null && this.mruList.isClosing(this);
    }

    boolean isMruEnabled() {
        return this.mruList != null && this.mruList.isEnabled();
    }

    private void mruListRemove() {
        if (this.mruList != null) {
            this.mruList.remove(this);
        }
    }

    private void mruListUse() {
        if (this.mruList != null) {
            this.mruList.use(this);
        }
    }

    private void mruListAdd() {
        if (this.mruList != null) {
            this.mruList.add(this);
        }
    }

    @Override
    public void open() throws IOException {
        this.getZipFile();
    }

    synchronized void incrementReference() {
        ++this.referenceCount;
    }

    synchronized void decrementReference() {
        this.referenceCount = Math.max(0, this.referenceCount - 1);
        if (this.referenceCount == 0) {
            this.notify();
        }
    }
}

