/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.filesystem;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import org.greenrobot.eclipse.core.internal.filesystem.Policy;
import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.core.runtime.Path;
import org.greenrobot.eclipse.osgi.service.datalocation.Location;
import org.greenrobot.osgi.framework.BundleContext;
import org.greenrobot.osgi.framework.FrameworkUtil;
import org.greenrobot.osgi.framework.InvalidSyntaxException;
import org.greenrobot.osgi.framework.ServiceReference;

public class FileSystemAccess {
    private static BundleContext context = FrameworkUtil.getBundle(FileSystemAccess.class).getBundleContext();

    public static IPath getCacheLocation() {
        try {
            ServiceReference<Location> ref;
            Location location;
            Collection<ServiceReference<Location>> refs;
            if (context != null && (refs = context.getServiceReferences(Location.class, Location.INSTANCE_FILTER)) != null && refs.size() == 1 && (location = context.getService(ref = refs.iterator().next())) != null) {
                Path instancePath = new Path(new File(location.getURL().getFile()).toString());
                context.ungetService(ref);
                return instancePath.append(".metadata/.plugins").append("org.greenrobot.eclipse.core.filesystem");
            }
        }
        catch (InvalidSyntaxException e) {
            Policy.log(1, null, e);
        }
        return Path.fromOSString(System.getProperty("user.home"));
    }

    public static Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        if (context != null) {
            return context.getBundle().findEntries(path, filePattern, recurse);
        }
        return null;
    }
}

