/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.refresh;

import org.greenrobot.eclipse.core.internal.refresh.MonitorManager;
import org.greenrobot.eclipse.core.internal.refresh.PollingMonitor;
import org.greenrobot.eclipse.core.internal.refresh.RefreshManager;
import org.greenrobot.eclipse.core.internal.resources.Workspace;
import org.greenrobot.eclipse.core.resources.IResource;
import org.greenrobot.eclipse.core.resources.refresh.IRefreshMonitor;
import org.greenrobot.eclipse.core.runtime.IProgressMonitor;
import org.greenrobot.eclipse.core.runtime.SubMonitor;

public class InternalRefreshProvider {
    protected IRefreshMonitor createPollingMonitor(IResource resource) {
        Workspace workspace = (Workspace)resource.getWorkspace();
        RefreshManager refreshManager = workspace.getRefreshManager();
        MonitorManager monitors = refreshManager.monitors;
        PollingMonitor pollingMonitor = monitors.pollMonitor;
        pollingMonitor.monitor(resource);
        return pollingMonitor;
    }

    public void resetMonitors(IResource resource, IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert(progressMonitor, 2);
        MonitorManager manager = ((Workspace)resource.getWorkspace()).getRefreshManager().monitors;
        manager.unmonitor(resource, subMonitor.split(1));
        manager.monitor(resource, subMonitor.split(1));
    }
}

