/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.resources.mapping;

import java.util.ArrayList;
import org.greenrobot.eclipse.core.internal.resources.MarkerManager;
import org.greenrobot.eclipse.core.internal.resources.Workspace;
import org.greenrobot.eclipse.core.resources.IMarker;
import org.greenrobot.eclipse.core.resources.IResource;
import org.greenrobot.eclipse.core.resources.IResourceVisitor;
import org.greenrobot.eclipse.core.resources.ResourcesPlugin;
import org.greenrobot.eclipse.core.runtime.CoreException;

public class ResourceTraversal {
    private final int depth;
    private final int flags;
    private final IResource[] resources;

    public ResourceTraversal(IResource[] resources, int depth, int flags) {
        if (resources == null) {
            throw new NullPointerException();
        }
        this.resources = resources;
        this.depth = depth;
        this.flags = flags;
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IResource resource = iResourceArray[n2];
                try {
                    if (resource.exists()) {
                        resource.accept(visitor, this.depth, this.flags);
                    }
                }
                catch (CoreException e) {
                    if (e.getStatus().getCode() == 368) break block4;
                    throw e;
                }
            }
            ++n2;
        }
    }

    public boolean contains(IResource resource) {
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (this.contains(member, resource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean contains(IResource resource, IResource child) {
        if (resource.equals(child)) {
            return true;
        }
        if (this.depth == 0) {
            return false;
        }
        if (child.getParent().equals(resource)) {
            return true;
        }
        if (this.depth == 2) {
            return resource.getFullPath().isPrefixOf(child.getFullPath());
        }
        return false;
    }

    void doFindMarkers(ArrayList<IMarker> result, String type, boolean includeSubtypes) {
        MarkerManager markerMan = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager();
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            markerMan.doFindMarkers(resource, result, type, includeSubtypes, this.depth);
            ++n2;
        }
    }

    public IMarker[] findMarkers(String type, boolean includeSubtypes) throws CoreException {
        if (this.resources.length == 0) {
            return new IMarker[0];
        }
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        this.doFindMarkers(result, type, includeSubtypes);
        return result.toArray(new IMarker[result.size()]);
    }

    public int getDepth() {
        return this.depth;
    }

    public int getFlags() {
        return this.flags;
    }

    public IResource[] getResources() {
        return this.resources;
    }
}

