/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core;

import java.util.Set;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.core.runtime.IProgressMonitor;
import org.greenrobot.eclipse.jdt.core.IClasspathEntry;
import org.greenrobot.eclipse.jdt.core.JavaModelException;
import org.greenrobot.eclipse.jdt.internal.core.ExternalFoldersManager;
import org.greenrobot.eclipse.jdt.internal.core.JavaModelManager;
import org.greenrobot.eclipse.jdt.internal.core.JavaProject;

public class ExternalFolderChange {
    private JavaProject project;
    private IClasspathEntry[] oldResolvedClasspath;

    public ExternalFolderChange(JavaProject project, IClasspathEntry[] oldResolvedClasspath) {
        this.project = project;
        this.oldResolvedClasspath = oldResolvedClasspath;
    }

    public void updateExternalFoldersIfNecessary(boolean refreshIfExistAlready, IProgressMonitor monitor) throws JavaModelException {
        Set<IPath> oldFolders = ExternalFoldersManager.getExternalFolders(this.oldResolvedClasspath);
        IClasspathEntry[] newResolvedClasspath = this.project.getResolvedClasspath();
        Set<IPath> newFolders = ExternalFoldersManager.getExternalFolders(newResolvedClasspath);
        if (newFolders == null) {
            return;
        }
        ExternalFoldersManager foldersManager = JavaModelManager.getExternalManager();
        for (IPath folderPath : newFolders) {
            if (oldFolders != null && oldFolders.remove(folderPath) && !foldersManager.removePendingFolder(folderPath)) continue;
            try {
                foldersManager.createLinkFolder(folderPath, refreshIfExistAlready, monitor);
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
    }

    public String toString() {
        return "ExternalFolderChange: " + this.project.getElementName();
    }
}

