/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core;

import java.io.IOException;
import java.util.Map;
import org.greenrobot.eclipse.core.resources.IResource;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IProgressMonitor;
import org.greenrobot.eclipse.jdt.core.CompletionRequestor;
import org.greenrobot.eclipse.jdt.core.IBuffer;
import org.greenrobot.eclipse.jdt.core.ICompilationUnit;
import org.greenrobot.eclipse.jdt.core.IJavaElement;
import org.greenrobot.eclipse.jdt.core.IModularClassFile;
import org.greenrobot.eclipse.jdt.core.IModuleDescription;
import org.greenrobot.eclipse.jdt.core.IType;
import org.greenrobot.eclipse.jdt.core.JavaCore;
import org.greenrobot.eclipse.jdt.core.JavaModelException;
import org.greenrobot.eclipse.jdt.core.WorkingCopyOwner;
import org.greenrobot.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.greenrobot.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.greenrobot.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.greenrobot.eclipse.jdt.internal.core.AbstractClassFile;
import org.greenrobot.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.greenrobot.eclipse.jdt.internal.core.BecomeWorkingCopyOperation;
import org.greenrobot.eclipse.jdt.internal.core.BinaryModule;
import org.greenrobot.eclipse.jdt.internal.core.BufferManager;
import org.greenrobot.eclipse.jdt.internal.core.ClassFileInfo;
import org.greenrobot.eclipse.jdt.internal.core.ClassFileWorkingCopy;
import org.greenrobot.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.greenrobot.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.greenrobot.eclipse.jdt.internal.core.JavaElement;
import org.greenrobot.eclipse.jdt.internal.core.JavaModelManager;
import org.greenrobot.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.greenrobot.eclipse.jdt.internal.core.NamedMember;
import org.greenrobot.eclipse.jdt.internal.core.OpenableElementInfo;
import org.greenrobot.eclipse.jdt.internal.core.PackageFragment;
import org.greenrobot.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.greenrobot.eclipse.jdt.internal.core.PackageFragmentRootInfo;
import org.greenrobot.eclipse.jdt.internal.core.SourceMapper;
import org.greenrobot.eclipse.jdt.internal.core.nd.java.model.BinaryModuleDescriptor;
import org.greenrobot.eclipse.jdt.internal.core.nd.java.model.BinaryModuleFactory;
import org.greenrobot.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.greenrobot.eclipse.jdt.internal.core.util.Util;

public class ModularClassFile
extends AbstractClassFile
implements IModularClassFile {
    private BinaryModule binaryModule;

    protected ModularClassFile(PackageFragment parent) {
        super(parent, "module-info");
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        IBinaryModule moduleInfo = this.getBinaryModuleInfo();
        if (moduleInfo == null) {
            info.setChildren(JavaElement.NO_ELEMENTS);
            return false;
        }
        BinaryModule module = new BinaryModule((JavaElement)this, moduleInfo);
        newElements.put(module, moduleInfo);
        info.setChildren(new IJavaElement[]{module});
        this.binaryModule = module;
        if (info instanceof ClassFileInfo) {
            ((ClassFileInfo)info).setModule(module);
        }
        ((PackageFragmentRootInfo)this.getPackageFragmentRoot().getElementInfo()).setModule(module);
        return true;
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        String source = this.getSource();
        if (source != null) {
            BasicCompilationUnit cu = new BasicCompilationUnit(this.getSource().toCharArray(), null, "module-info.java", this.getJavaProject());
            this.codeComplete(cu, cu, offset, requestor, owner, null, monitor);
        }
    }

    @Override
    public IJavaElement[] codeSelect(int offset, int length, WorkingCopyOwner owner) throws JavaModelException {
        char[] contents;
        IBuffer buffer = this.getBuffer();
        if (buffer != null && (contents = buffer.getCharacters()) != null) {
            BasicCompilationUnit cu = new BasicCompilationUnit(contents, null, "module-info.java", this);
            return super.codeSelect(cu, offset, length, owner);
        }
        return new IJavaElement[0];
    }

    @Override
    public IType findPrimaryType() {
        return null;
    }

    @Override
    public boolean isClass() throws JavaModelException {
        return false;
    }

    @Override
    public boolean isInterface() throws JavaModelException {
        return false;
    }

    @Override
    public IType getType() {
        throw new UnsupportedOperationException("IClassFile#getType() cannot be used on an IModularClassFile");
    }

    public IBinaryModule getBinaryModuleInfo() throws JavaModelException {
        try {
            IBinaryModule info = this.getJarBinaryModuleInfo();
            if (info == null) {
                throw this.newNotPresentException();
            }
            return info;
        }
        catch (ClassFormatException cfe) {
            if (JavaCore.getPlugin().isDebugging()) {
                cfe.printStackTrace(System.err);
            }
            return null;
        }
        catch (IOException ioe) {
            throw new JavaModelException(ioe, 985);
        }
        catch (CoreException e) {
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
    }

    private IBinaryModule getJarBinaryModuleInfo() throws CoreException, IOException, ClassFormatException {
        BinaryModuleDescriptor descriptor = BinaryModuleFactory.createDescriptor(this);
        if (descriptor == null) {
            return null;
        }
        IBinaryModule result = null;
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (this.getPackageFragmentRoot() instanceof JarPackageFragmentRoot) {
            if (root instanceof JrtPackageFragmentRoot || this.name.equals("module-info")) {
                String entryName;
                PackageFragment pkg = (PackageFragment)this.getParent();
                JarPackageFragmentRoot jarRoot = (JarPackageFragmentRoot)this.getPackageFragmentRoot();
                byte[] contents = this.getClassFileContent(jarRoot, entryName = jarRoot.getClassFilePath(Util.concatWith(pkg.names, this.getElementName(), '/')));
                if (contents != null) {
                    String fileName = String.valueOf(root.getHandleIdentifier()) + '|' + entryName;
                    ClassFileReader classFileReader = new ClassFileReader(contents, fileName.toCharArray(), false);
                    return classFileReader.getModuleDeclaration();
                }
            } else {
                result = BinaryModuleFactory.readModule(descriptor, null);
            }
        } else {
            result = BinaryModuleFactory.readModule(descriptor, null);
        }
        return result;
    }

    @Override
    public IJavaElement getElementAt(int position) throws JavaModelException {
        IJavaElement parentElement = this.getParent();
        while (parentElement.getElementType() != 3) {
            parentElement = parentElement.getParent();
        }
        PackageFragmentRoot root = (PackageFragmentRoot)parentElement;
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        this.getBuffer();
        IModuleDescription module = this.getModule();
        return this.findElement(module, position, mapper);
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '`': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String modName = memento.nextToken();
                BinaryModule mod = new BinaryModule((JavaElement)this, modName);
                return mod.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '\'';
    }

    @Override
    protected void escapeMementoName(StringBuffer buffer, String mementoName) {
    }

    @Override
    public ICompilationUnit getWorkingCopy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        ClassFileWorkingCopy workingCopy = new ClassFileWorkingCopy(this, owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy, false, true, null);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation op = new BecomeWorkingCopyOperation(workingCopy, null);
        op.runOperation(monitor);
        return workingCopy;
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            return this.mapSource(mapper);
        }
        return null;
    }

    private IBuffer mapSource(SourceMapper mapper) throws JavaModelException {
        char[] contents = mapper.findSource(this.getModule());
        if (contents != null) {
            IBuffer buffer = BufferManager.createBuffer(this);
            if (buffer == null) {
                return null;
            }
            BufferManager bufManager = this.getBufferManager();
            bufManager.addBuffer(buffer);
            if (buffer.getCharacters() == null) {
                buffer.setContents(contents);
            }
            buffer.addBufferChangedListener(this);
            mapper.mapSource((NamedMember)((Object)this.getModule()), contents, null);
            return buffer;
        }
        IBuffer buffer = BufferManager.createNullBuffer(this);
        if (buffer == null) {
            return null;
        }
        BufferManager bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    @Override
    public IModuleDescription getModule() throws JavaModelException {
        if (this.binaryModule == null) {
            this.openWhenClosed(this.createElementInfo(), false, null);
            if (this.binaryModule == null) {
                throw this.newNotPresentException();
            }
        }
        return this.binaryModule;
    }
}

