/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.dom.rewrite;

import org.greenrobot.eclipse.jdt.core.dom.ASTNode;
import org.greenrobot.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.greenrobot.eclipse.jface.text.IRegion;
import org.greenrobot.eclipse.text.edits.TextEdit;
import org.greenrobot.eclipse.text.edits.TextEditGroup;

public class TrackedNodePosition
implements ITrackedNodePosition {
    private final TextEditGroup group;
    private final ASTNode node;

    public TrackedNodePosition(TextEditGroup group, ASTNode node) {
        this.group = group;
        this.node = node;
    }

    @Override
    public int getStartPosition() {
        if (this.group.isEmpty()) {
            return this.node.getStartPosition();
        }
        IRegion coverage = TextEdit.getCoverage(this.group.getTextEdits());
        if (coverage == null) {
            return this.node.getStartPosition();
        }
        return coverage.getOffset();
    }

    @Override
    public int getLength() {
        if (this.group.isEmpty()) {
            return this.node.getLength();
        }
        IRegion coverage = TextEdit.getCoverage(this.group.getTextEdits());
        if (coverage == null) {
            return this.node.getLength();
        }
        return coverage.getLength();
    }
}

