/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.nd.db;

import java.util.List;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.ModificationLog;

public class RelatedAddress {
    private final String description;
    private final long address;
    private final int size;
    private final ModificationLog.MemoryAccessLog modificationReport;

    public RelatedAddress(String description, long address, int size, ModificationLog.MemoryAccessLog lastModification) {
        this.description = description;
        this.address = address;
        this.size = size;
        this.modificationReport = lastModification;
    }

    boolean isSameAddressAs(RelatedAddress other) {
        return other.address == this.address && other.size == this.size;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.description);
        builder.append(" [address ");
        builder.append(this.address);
        builder.append(", size ");
        builder.append(this.size);
        builder.append("]: ");
        ModificationLog.MemoryAccessLog reducedReport = this.modificationReport.reduce(5);
        List<ModificationLog.MemoryOperation> operations = reducedReport.getOperations();
        if (operations.isEmpty()) {
            builder.append("No modification report");
        } else {
            builder.append("\n");
            for (ModificationLog.MemoryOperation nextOperation : operations) {
                nextOperation.printTo(builder, 1);
            }
        }
        return builder.toString();
    }
}

